###Building 64-bit libraries  
Follow the instructions at the following link to get MinGW64 and msys64 on your machine and be sure to do the post-installation tasks. Then you're ready to build 64-bit. All 64-bit builds must be run from msys64 using MinGW64.

http://www.gaia-gis.it/spatialite-3.0.0-BETA/mingw64_how_to.html

###FFMPEG

We build ffmpeg with all encoders, decoders, muxers, protocols, etc. turned off. First run ./configure in MSYS as follows:

	$ CPPFLAGS='-DHAVE_INT32_T' ./configure --prefix=/mingw --disable-ffmpeg --disable-ffplay --disable-ffprobe --disable-ffserver --disable-avdevice --disable-swscale --disable-postproc --disable-avfilter --disable-everything --enable-runtime-cpudetect --enable-memalign-hack --disable-debug --enable-shared --disable-static --build-suffix=-ttv

For 64-bit use the following:  

	$ CPPFLAGS='-DHAVE_INT32_T' ./configure --prefix=/mingw --enable-cross-compile --cross-prefix=x86_64-w64-mingw32- --target-os=mingw32 --arch=x86_64 --disable-doc --disable-ffmpeg --disable-ffplay --disable-ffprobe --disable-ffserver --disable-avdevice --disable-swscale --disable-postproc --disable-avfilter --disable-everything --enable-runtime-cpudetect --enable-memalign-hack --disable-debug --enable-shared --disable-static --build-suffix=-ttv
Then just run  

	make

Once the build is done, we need to run the lib tool to generate import libraries. We only use ffmpeg for channel mapping and audio resampling, so we only need libswresample which uses avutil. For each of libavutil and libswresample, run the following from the Visual Studio command prompt (use /machine:x64 for 64-bit):

	lib /machine:i386 /def:<name>.def /out:<name>.lib

###LAME MP3

To build LAME, run the following command in MSYS:

	./configure --prefix=/mingw --enable-expopt=full

For 64-bit, add the following flag:

	--host=x86_64-w64-mingw32

Then generate the DLL by running  

	make

Now you need to generate the import lib. Go to /libmp3lame/.libs and generate a .def file from the DLL you've built by running this command from the VS command prompt: 
 
	dumpbin /exports libmp3lame-0.dll > libmp3lame.def  

Open the generated .def file in a text editor and edit it to have the following format:

	LIBRARY libmp3lame-ttv.dll  
	EXPORTS  
	<export name 1>  
	<export name 2>  
	<export name 3>  
	...  

Finally run this command from the VS prompt (use /machine:x64 for 64-bit):  

	lib /def:libmp3lame.def /out:libmp3lame-ttv.lib /machine:x86  

#### ios

```
#!/bin/bash

SDK_VERSION="6.0"

mkdir build

function build_lame()
{
    make distclean

    ./configure \
        CFLAGS="-isysroot /Applications/Xcode.app/Contents/Developer/Platforms/${SDK}.platform/Developer/SDKs/${SDK}${SDK_VERSION}.sdk" \
        CC="/Applications/Xcode.app/Contents/Developer/Platforms/${SDK}.platform/Developer/usr/bin/gcc -arch ${PLATFORM}" \
        --prefix=/Users/zach/Downloads/lame-3.99.5 \
        --host="arm-apple-darwin9" \
        --disable-shared \
        --enable-static \
        --disable-decoder \
        --disable-frontend

    make
    cp "libmp3lame/.libs/libmp3lame.a" "build/libmp3lame-${PLATFORM}.a"
}

PLATFORM="i686"
SDK="iPhoneSimulator"
build_lame

PLATFORM="armv6"
SDK="iPhoneOS"
build_lame

PLATFORM="armv7"
build_lame

PLATFORM="armv7s"
build_lame

lipo -create build/* -output build/libmp3lame.a
```

###libcurl

To build libcurl we first need to build OpenSSL. The instructions for building OpenSSL are in this document: https://github.com/downloads/justintv/sdk/Using-libcurl-with-SSH-support-in-Visual-Studio-2010.pdf.  
##### Important: Before running nmake, edit the ms\ntdll.mak file to change /MD to /MT in CFLAGS. This ensures that the DLL's are built using the static version of CRT.  
To build in 64-bit, do the following (http://stackoverflow.com/questions/158232/how-do-you-compile-openssl-for-x64):
* Run the "VS 2010 x64 Cross Tools Command Prompt"
* Run 
	perl Configure VC-WIN64A --prefix=c:/openssl_lib

* Run ms\do_win64a
* Edit ms\ntdll.mak and change 32 to 64 in output dirs:  
	OUT_D=out64dll  
	TMP_D=tmp64dll  
	INC_D=inc64  
	INCO_D=inc64\openssl  

* Run nmake -f ms\ntdll.mak  

Once you have built OpenSSL, you can build libcurl in Visual Studio. Use the vc6libcurl project that's under the \lib folder in the curl download. There you can build the Debug and Release DLL configs. You need to modify the project to add the following defines:  

	USE_SSLEAY
	USE_OPENSSL

You also need to add the include and linker paths for openssl. Also make sure you use the non-DLL version of the Runtime Library (Under Properties=>C/C++=>Code Generation).  

###### Note: In order to add the '-ttv' suffix to the names of the lib/dll files we need to do the following:
* Edit the Configure file and change the few places where libeay32 and ssleay32 appear to libeay32-ttv and ssleay32-ttv before running the Perl command  
* After running ms/do_ms (or ms/do_win64a) add -ttv to the names of the libeay32/ssleay32.def files under /ms/  
* Edit the two .def files above and update the name of the LIBRARY at the top of the file with the -ttv suffix  
* Edit the generated ntdll.mak file and append -ttv to instances of ssleay32 and libeay32 before running nmake  
* Edit the vc6libcurl project to link against the libeay32/ssleay32 .lib files with -ttv in their name and change the ourput .dll and .lib of the project to have -ttv in the name (i.e. libculr-ttv.lib/.dll)  

#### Mac

Use the version Apple ships

#### iOS

```
#!/bin/sh 
export SDK=6.0

buildit()
{
    target=$1
    platform=$2

    export CC=/Applications/Xcode.app/Contents/Developer/Platforms/${platform}.platform/Developer/usr/bin/gcc
    export CFLAGS="-arch ${target} -isysroot /Applications/Xcode.app/Contents/Developer/Platforms/${platform}.platform/Developer/SDKs/${platform}${SDK}.sdk"
    export CPP="/Applications/Xcode.app/Contents/Developer/Platforms/${platform}.platform/Developer/usr/bin/llvm-cpp-4.2"
    export AR=/Applications/Xcode.app/Contents/Developer/Platforms/${platform}.platform/Developer/usr/bin/ar
    export RANLIB=/Applications/Xcode.app/Contents/Developer/Platforms/${platform}.platform/Developer/usr/bin/ranlib

    ./configure --disable-shared --host=${target}-apple-darwin10

    make clean
    make
    $AR rv libcurl.${target}.a lib/*.o
}

buildit armv7s iPhoneOS
buildit armv7 iPhoneOS
buildit i386 iPhoneSimulator

lipo -create libcurl.armv7.a libcurl.armv7s.a libcurl.i386.a -output libcurl.a
```


###x264

You can build x264 using the Intel Compiler. To do this follow the instructions here:
http://doom10.org/index.php?topic=1767.0

For building 64-bit, in config_only.bat and make_only.bat. Also in config.sh you should set the --enable-shared and --disable-gpl options for ./configure. You can use --enable-debug to turn on debug symbols (note that we currently build with --enable-debug to get around a crash in x264).

To build x264 from MSYS (MSYS64 for 64-bit) run the following commands:

	./configure --enable-shared --disable-gpl --prefix=/mingw
	make fprofiled VIDS="path to video file to use for optimization"

For 64-bit:  

	./configure --enable-shared --disable-gpl --prefix=/mingw --cross-prefix=x86_64-w64-mingw32- --host=x86_64-pc-mingw32
	make VIDS="path to video file to use for optimization"

To generate the import lib, follow the same steps as LAME MP3 above to generate a .def and .lib file.

Useful link: http://doom10.org/index.php?topic=26.0

#### iOS

```
#!/bin/sh

# This script is originally based off of the one by Gabriel Handford
# Original scripts can be found here: https://github.com/gabriel/ffmpeg-iphone-build
# Modified by Roderick Buenviaje
# Yet another modification by Radek Skokan
# And then again by Zach Drayer
# Builds versions of the VideoLAN x264 for armv7s and armv7
# Combines the two libraries into a single one
#
# To use the script, make sure you have GCC/LLVM-GCC installed: Xcode/Preferences/Downloads/Components/Command Line Tools

trap exit ERR

export DIR=./x264
export DEST7S=armv7s/
export DEST7=armv7/

#specify the version of iOS you want to build against
export VERSION="6.0"

export ISYSROOT="/Applications/Xcode.app/Contents/Developer/Platforms/iPhoneOS.platform/Developer/SDKs/iPhoneOS${VERSION}.sdk"

mkdir -p $DIR
git clone git://git.videolan.org/x264.git x264
cd $DIR

echo "Building armv7s..."

export CC=/Applications/Xcode.app/Contents/Developer/Platforms/iPhoneOS.platform/Developer/usr/bin/llvm-gcc
./configure --host=arm-apple-darwin \
--sysroot=$ISYSROOT \
--prefix=$DEST7S \
--extra-cflags='-arch armv7s'\
 --extra-ldflags="-L${ISYSROOT}/usr/lib/system -arch armv7s" \
--enable-pic --enable-static \
--disable-asm

make && make install

echo "Installed: $DEST7S"
echo "Building armv7..."

export CC=/Applications/Xcode.app/Contents/Developer/Platforms/iPhoneOS.platform/Developer/usr/bin/llvm-gcc
./configure --host=arm-apple-darwin \
--sysroot=$ISYSROOT \
--prefix=$DEST7 \
--extra-cflags='-arch armv7' \
--extra-ldflags="-L${ISYSROOT}/usr/lib/system -arch armv7" \
--enable-pic --enable-static

make && make install

echo "Installed: $DEST7"

echo "Combining Libraries"
ARCHS="armv7s armv7"

BUILD_LIBS="libx264.a"

OUTPUT_DIR="x264-uarch"
mkdir -p $OUTPUT_DIR/lib
mkdir -p $OUTPUT_DIR/include

lipo -create $DEST7S/lib/libx264.a $DEST7/lib/libx264.a -output $OUTPUT_DIR/lib/libx264.a
cp -f $DEST7/include/*.* $OUTPUT_DIR/include/
```