##Getting The Latest Release
- Go to https://github.com/twitchtv/sdk-dist
- Download https://github.com/twitchtv/sdk-dist/blob/master/java/TwitchJava.jar
- Download the files under https://github.com/twitchtv/sdk-dist/tree/master/java/src
- Download the files under https://github.com/twitchtv/sdk-dist/tree/master/external/win32 (for 32-bit Windows support)
- Download the files under https://github.com/twitchtv/sdk-dist/tree/master/external/x64 (for 64-bit Windows support)
- Download https://github.com/twitchtv/sdk-dist/blob/master/java/x86/twitchsdk.dll (for 32-bit Windows support)
- Download https://github.com/twitchtv/sdk-dist/blob/master/java/x64/twitchsdk.dll (for 64-bit Windows support)
- Download https://github.com/twitchtv/sdk-dist/blob/master/java/mac/libtwitchsdk.dylib (for Mac support)

##Windows 32 Bit
- Place all .java files except Gears.java in your project
- Gears.java is a very basic example of how to integrate.  It is not the most efficient.
- Add TwitchJava.jar to your project
- Place the 32-bit Windows files into a directory in your project (native/x86, for example)
- Open BroadcastController.java
	- Hard-code your ClientId and ClientSecret fields (get these through your account on the site)
	- Temporarily hard-code your username, password, broadcast height/width and broadcast FPS until you create UI for setting the values
- See Gears.java for a simple, inefficient, brute force method for implementing broadcasting.  It captures the pixels from the frame buffer directly.
- Add -Djava.library.path=native/x32 to the library path.  
- Add native/x32 to the PATH variable for the JVM execution.  This is because twitchsdk.dll needs to find its dependencies and the JVM does not add the java.library.path you set to the PATH.
- The proper way to capture will depend on your game's rendering pipeline but should go something like the following:
	- Render your scene to a texture which has the same resolution as the window you will draw to
	- Render the scene texture to the screen
	- Render the scene texture UPSIDE DOWN to another render texture which has the same resolution as the broadcast resolution (keep in mind that you may be broadcasting at a different resolution than the game window).  Rendering upside down will save us from having to manually flip the image vertically after capturing it
	- After rendering to the broadcast texture call BroadcastController.captureFrameBuffer_ReadPixels() with the broadcast texture bound.  Make sure flipping is set to false

##Windows 64 Bit
- Mostly the same as 32 bit except:
	- Place the 64-bit Windows files into a directory in your project (native/x64, for example)
	- Add this directory to java.library.path and PATH when running under 64 bit.

##Mac 32 Bit
- Not supported.

##Mac 64 Bit
- Follow the instructions for Windows 32 Bit except:
	- Copy libtwitchsdk.dylib to the native libraries directory of your project.
	- Add this directory to java.library.path.

##Common Issues
* You will receive TTV_EC_API_REQUEST_FAILED as an error if you attempt to use a client id you create without first sending it to Twitch for white-listing.  Email it to your Twitch contact to have it approved.