##Miscellaneous  
- If you change any API you will have to update all the implementations of BroadcastController and ChatController.  These currently live under the samples.  The base BroadcastController and ChatController are under twitchsdk\samples\unity\Assets\Twitch\Scripts.  
- Each platform (Unity, Java, WinForms, XNA) each implement a class derived from BroadcastController.  Same for ChatController.  These implementations live under the respective sample directory.  
- Any SDK functions that expect to hold onto some struct instance to fill in during an async request won't work with the wrappers.  You'll see that there are some alternate functions exported which will create the instance natively and then call a callback into the wrapper code when the result is available.  
- In the language bindings, the controllers talk to the high level API interfaces (Core, Stream and Chat).  These high level interfaces contain a reference to the actual implementation of the API such as UnityDesktopStreamAPI, XNADesktopStreamAPI, etc.  The native functions called might be different for each implementation which is why the high level interface is there to hide the details.  

##Java
###Useful Links  
https://github.com/twitchtv/sdk-dist/wiki/Twitch-Java-Plugin  

###Setup
####Windows
- Download and install the latest Eclipse from http://www.eclipse.org
- Download and install the latest release of Java SE 6 from http://www.oracle.com/technetwork/java/javase/downloads/index.html.  You will need to grab the 32-bit and 64-bit versions.
- Download version 2.8.5 of LWJGL from http://lwjgl.org.  This is what Minecraft was using and is what the Gears demo is written against.
- Add the Gears project found under samples to your Eclipse workspace.  You may have to fix some paths since Eclipse doesn't manage relative paths well.
- Setup a debug configuration for Gears.  You will need to configure both the JDK used depending on whether you want to run in 32-bit or 64-bit.
    - Add -Djava.library.path=<native DLLs path> variable to the JVM arguments.
    - Add the same <native DLLs path> to the PATH variable for the JVM execution. This is because twitchsdk.dll needs to find its dependencies and the JVM does not add the java.library.path you set to the PATH.
- See the public Java instructions for more setup details.

####Mac
- Setup is mostly the same as for Windows but you should not have to
    - Download a JDK
    - Set the PATH variable

###General
- Java code for the bindings can be found under twitchsdk\bindings\java.
- Write the java versions of the SDK types.  
- In C++, write the functions in java_streamutil.cpp that lookup java type information for use in C++.  
    - twitchsdk\bindings\java\dump_class.bat is helpful for dumping the java type info for a class.  
- If you add or remove native functions exposed by Java you need to regenerate the C header for Java class.  
    - twitchsdk\bindings\java\generate_headers.bat is helpful for generating the headers.  
- Core.java, Stream.java and Chat.java wrap the Java API class used.  
- StandardCoreApi.java, DesktopStreamApi.java and StandardChatApi.java are the native API implementations.  If you change any functions in these file you will have to rerun the header generation and update the C++ implementation.  
- Make sure you update the def/exp files with any added or removed functions.  

###Windows
- You need to build 2 twitchsdk.dll, one for 32 bit and one for 64 bit.  Both need to be named twitchsdk.dll so keep them in different directories.  
- The .def file is generated by a Pre-Link step that preprocesses include/internal/win32/twitchsdk.def.h with TTV_EXPORT_BINDINGS defined.  

###Mac
- You need to build a single dylib via the sdk-mac-dynamic-java config with both 32 and 64 bit support.  This dylib must be named libtwitchsdk.dylib in order for Java to find and load it.  
- The .exp file is generated during a build by a Build Phase that preprocesses include/internal/darwin/twitchsdk.exp.h with TTV_EXPORT_BINDINGS defined.  

##Unity  
###Useful Links  
https://github.com/twitchtv/sdk-dist/wiki/Twitch-Unity-Plugin  
http://docs.unity3d.com/Documentation/Manual/Plugins.html  

###Setup
####Windows
- Download and install the latest Unity 4.
- You will need a license for Unity Pro.  Also iOS if ever get working on iOS again.  We currently have a single license for both Pro and iOS that will work on 2 machines.  If you're the only one working on Unity you should deauthorize the license for the previous engineer's machines and authorize it for your 2 machines.  Authorize your Windows machine as the first use of the license.

####Mac
- Download and install the latest Unity 4.
- Use the same license as for Windows and authorize it for the Mac machine.  This will consume the second use.

###General  
- C# code for the bindings can be found under twitchsdk\bindings\csharp.
- C# is able to PInvoke and call exported DLL functions explicitly.  
- You can't rerun 64-bit from the editor.  You need to make a build and test the 64-bit build.  The 32-build is always run in the editor.  
- When editing the code be sure to take into account that both DirectX 9 and OpenGL 2 need to be maintained.  Also, if we end up supporting iOS/Android then the GLES 1 and GLES 2 capturers need to be maintained as well.  

###Windows  
- Same as Java.  

###Mac  
- You need to build a bundle, not just a dylib.  See http://www.tedlindstrom.se/how-to-link-dylibs-into-unity3d.  
- The sdk-mac-dynamic-unity config builds the .dylib for use in the twitchsdkbundle project.  The dylib is 32 bit only and cannot be 64 bit or contain both 32/64 bit.  
- twitchsdkbundle is the project that builds the bundle for Unity.  

##WinForms
###General
- C# code for the bindings can be found under twitchsdk\bindings\csharp.
- This plugin works much like the Unity plugin but is only supported for Windows.  
- The sample app is under twitchsdk\samples\winforms.

##XNA
###General
- C# code for the bindings can be found under twitchsdk\bindings\csharp.
- This plugin works much like the Unity plugin but is only supported for Windows.  
- The sample app is under twitchsdk\samples\xna.