##Introduction  
The Twitch Unity plugin provides the functionality you need to integrate Twitch broadcasting and chat into your Unity game.  

Please note that the plugin is currently in development so interfaces and functionality may change between releases.  

##Current Unity Support
- Only Unity 4.x is supported
- Requires Unity Pro.

##Currently Supported Platforms
- Windows 32 and 64 bit
	- Direct3D 9
	- Direct3D 11
	- OpenGL 2.1

- Mac OS X 32 and 64 bit
	- OpenGL 2.1

- iOS 7
	- GLES 2

##Getting The Latest Release
- Go to https://github.com/twitchtv/sdk-dist
- Download the files under https://github.com/twitchtv/sdk-dist/tree/master/external/win32 (for 32-bit Windows support)
- Download the files under https://github.com/twitchtv/sdk-dist/tree/master/external/x64 (for 64-bit Windows support)
- Download https://github.com/twitchtv/sdk-dist/blob/master/unity/TwitchUnity.unitypackage

##General Editor Setup
- Import TwitchUnity.unitypackage into a blank project
- Place the win32 files under Assets/Plugins/x86 (Windows only)
- Place the x64 files under Assets/Plugins/x86_64 (Windows only)

To get an auto-generated Unity iOS Xcode project to compile:
- Add libc++.1.lib
- Add libsdk-ios-unity.a
- Add Accelerate.framework

##Trying Broadcasting in the Sample
- Add all 4 scenes into File->Build Settings->Scenes In Build list
- Switch to the Twitch scene
- Set your ClientId and ClientSecret fields in _Twitch/Broadcast/BroadcastController component (get these through your account on the Twitch website)
- Set your username and password in the _Twitch/Broadcast/BroadcastGUI component
- Switch to the Bootstrap scene which loads the persistent Twitch scene and kicks off the first game scene
- Start the game
- Click Init
- Click Request Auth Token (or Use Existing Auth Token on consecutive runs) and wait for the state to say "ReadyToBroadcast"
- Click Start
- Go to your channel page and see that you're broadcasting

##Trying Chat in the Sample
- Add all 4 scenes into File->Build Settings->Scenes In Build list
- Switch to the Twitch scene
- Set your ClientId and ClientSecret fields in _Twitch/TwitchChat/ChatController component (get these through your account on the Twitch website)
- Set your username and password in the _Twitch/TwitchChat/ChatGUI component
- Switch to the Bootstrap scene which loads the persistent Twitch scene and kicks off the first scene
- Start the game
- Click Init
- Click Request Auth Token (or Use Existing Auth Token on consecutive runs) and wait for the state to say "ReadyToBroadcast"
- Click Connect and wait until the Send Message button appears
- _Twitch/TwitchChat/ChatGUI inspector enter some text in the Message field
- Click Send Message
- Go to the channel page and see that the chat message appears in the chat pane
- Enter some chat text on the channel page and switch back to the Unity game quickly
- Notice that the chat message appears for a few seconds in the viewport

##Integration Into Your Game
The provided code and libraries are broken into 3 categories: SDK, glue and examples.  

###SDK
This includes the native libraries and the C# wrapper library.  The native libraries are found in the platform specific directories under Assets/Plugins such as x86 and x86_64.  

The C# wrapper library is found at Assets/Plugins/TwitchSdkWrapper.dll.  This contains the low-level interface to the native SDK.  Most Unity developers will not directly call into this library.  The provided glue code will hide the need to deal with this library.

###Glue
These classes simplify the experience for the Unity developer by maintaining a high-level interface for broadcasting and chat.  These classes include BroadcastController, ChatController and IngestTester.  They should be included directly into your game.  This includes files under Assets/Twitch/Scripts.

###Examples
Everything that is under Assets/Twitch/Examples is intended to be used for demonstration purposes and as a starting point.  It is up to the game to implement their own GUI and render their frames into a RenderTexture.  However, most of the scripts under Examples can likely be used as they are with little modification.


##How the Broadcasting Plugin Works
The BroadcastController has a property called SceneRenderTexture which specifies the frame to be used for broadcasting.  This RenderTexture will be rendered to another RenderTexture which has the same dimensions as the broadcast.  Next, this BroadcastRenderTexture will be passed into native code during BroadcastController.Update() and captured asynchronously.  Once captured, the raw pixel data will be sent to the native SDK for encoding and streaming to the Twitch website.  

The frequency in which BroadcastController.Update() is called depends on your Unity project settings.  It must be configured to be called at least as often as the FPS setting you have set in VideoParams when you begin broadcasting.

###Windows-Specific
Audio is automatically captured from the entire system when BroadcastController.AudioEnabled is set to true.  All sound coming from other programs on the default playback device will be captured.  Also, all sound coming from the default recording device will be captured for the microphone.  Note that audio settings and data do not come directly from Unity.

###Mac-Specific
Audio is captured directly from Unity so you will not receive all system audio.

###iOS-Specific
Audio is captured directly from Unity so you will not receive all system audio.

##How the Chat Plugin Works
The ChatController is a thin and simple component that doesn't require any special scene setup to use.  The only requirement is that the BroadcastController be hooked up to it and initialized.

##Scripts
###Controller Scripts
These are components which manage the interface between your game and the low level wrapper code for the SDK library.  They are distributed in source form to help in debugging and so that they can be tweaked if needed.

####BroadcastController/UnityBroadcastController Monobehaviour
A component which manages the broadcasting state machine.  It provides a high level interface to the SDK libraries.  The BroadcastController (BC) performs many operations asynchronously and hides the details.  This can be tweaked if needed but should handle all your broadcasting needs.  

Events will be fired during the call to Update().

The typical order of operations a client of BC will take is:
- Call InitializeTwitch()
- Call RequestAuthToken() / Call SetAuthToken()
- Determine the server to use for broadcasting
- Call StartBroadcasting()
- Submit frames (this is done differently depending on platform), see platform-specific documentation for details
- Call StopBroadcasting()
- Call ShutdownTwitch()

When setting up the VideoParams for the broadcast you should use the bitrate version of GetRecommendedVideoParams.  This will setup the resolution and other parameters based on your connection to the server.  The other version is more explicit and may be useful for advanced users and testing but is generally more confusing and produces poorer results for the typical user who doesn't understand the settings.  We've found that many users just crank up the settings and don't understand why their broadcast doesn't look that great or the stream drops (network backup).  Simply giving the users a slider for maximum bitrate generally produces better visual quality.  In a more advanced integration the bitrate can actually be determined by ingest testing (see below).

The ingest server to use for broadcasting can be configured via the IngestServer property.  The list of servers can be retrieved from the IngestServers property.
Normally, the default server will be adequate and sufficiently close for decent broadcasting.  However, to be sure, you can perform ingest testing which will determine the connection speeds to all the Twitch servers.  This will help both in determining the best server to use (the server with the highest connection) and the actual bitrate to use when calculating the optimal VideoParams for that server. 

Ingest testing can be done by using the IngestTester class.  After logging into the BC, ingest testing can be performed by calling BC.StartIngestTest() which is only available in the ReadyForBroadcasting state.  This returns an instance of IngestTester which is a single-use instance.  This class will perform a test which will measure the connection speed to each of the Twitch ingest servers.  See the documentation of the class for details.  While the test is underway the BC is unavailable for any operations.

Once broadcasting begins, frames are submitted automatically for broadcasting in the Update() call.  The real time will be used to determine the rate of frame submission and is independent of Time.time.  At most one frame will be submitted per Update() call so you need to ensure that it will be called frequently enough to satisfy the FPS you have configured for broadcasting.  The maximum allowed time step will be a limiter in determining the maximum FPS in which the frames can be submitted for broadcasting.  For 30 FPS (which is the recommended maximum FPS allowed) make sure the project has a value of 0.03333 seconds configured for the "Maximum Allowed Timestep" property available via Edit->Project Settings->Time.  

The general setup for broadcasting is as follows:
- Render your scene to a RenderTexture at the same aspect ratio as the Screen.  Call this RenderTexture the scene RT.  
- Render the scene RT to the screen using a quad.  
- After hooking up the scene RT to the BroadcastController (BC), the BC will automatically setup the needed Camera and generate a RenderTexture which will be appropriate for generating the image for submitting for broadcasting.  

Concerning aspect ratios.  There are 3 aspect ratios (ARs) to consider when setting up your game: the screen, the broadcast and the video player on the website.  If any of these don't match then there will be black borders added to compensate, potentially at each different stage.  As of the time of this writing, the video player has an AR of 1.7777777 which is that of 1080p. If the Screen AR doesn't match the broadcast AR (configured by the width and height parameters in VideoParams) there will be bordering introduced to compensate. Then, if the broadcast AR doesn't match the video player AR then even more black bordering could be introduced.  Thus, ideally you'll setup VideoParams to have a 1.777777 AR (to match the video player) and configure the Screen resolution to as closely match the broadcast as possible.  

Another possibility could be to render the scene twice: once to the screen for the screen AR and another for the broadcast at an AR of 1.77777.  This would produce the best results but would most likely be too performance intensive so isn't recommended.

####ChatController/UnityChatController Monobehaviour
A component which manages the chat state machine.  It provides a high level interface to the SDK libraries.  The ChatController (CC) performs many operations asynchronously and hides the details.  This can be tweaked if needed but should handle all your chat needs (other than emoticons which may be provided in the future).

The typical order of operations a client of CC will take is:
- Subscribe for events via delegates on ChatController
- Initialize BroadcastController via BC.InitializeTwitch()
- Call CC.Connect() / call CC.ConnectAnonymous()
- Wait for the connection callback 
- Call CC.SendChatMessage() to send messages (if not connected anonymously)
- Receive message callbacks
- Call CC.Disconnect() when done

Events will fired during the call to CC.Update().  When chat messages are received RawMessagesReceived will be fired.

NOTE: The implementation of emoticon data is not yet complete and currently not available.

####IngestTester Script
A component created and returned by BroadcastController to test the bandwidth to the ingest servers.

Performs ingest bandwidth testing to determine the best server a user should connect to for broadcasting.  This will fill in the BitrateKbps field of the given IngestServers.  Testing may take a while because there are several servers to test and each one may be tested for several seconds.  This class cannot be used independently from the BroadcastController (BC) and is single-use only.  Begin a new test via BC.StartIngestTest().  

The IngestTester (IT) will fire events to indicate state changes such as the starting and stopping of a server test and completion of all tests.  

Progress of the overall test and of the current server can be gotten from TotalProgress and ServerProgress, respectively.  You may want to display a progress bar for each.  

The whole test can be cancelled via Cancel().  The current server test can be skipped via SkipCurrentServer() which will trigger the testing of the next server.  

###Example Scripts
These scripts demonstrate one possible way to structure your game with Twitch functionality.  They can be used mostly as is or ignored completely depending on how your game is structured.  

####RenderTextureResizer Monobehaviour
This component is responsible for creating and maintaining the scene RenderTexture that the game will render the scene to.  It handles resize events from the Unity Screen instance and automatically regenerates the screen RenderTexture.  It also updates the configured scene cameras and notifies them to update their projections.  When the RenderTexture is automatically updated it is connected to the configured BroadcastController.

####WebcamHelper Monobehaviour
A component which shows how to display a webcam image in the game.  This does not use any parts of the Twitch SDK and is merely a starting point on how to integrate into your game.  

####BootstrapLoader Monobehaviour
This sample component additively loads the Twitch scene so it can persist throughout the entire lifetime of your game.  It then loads the initial scene that's configured to load.  

####BroadcastGUI Monobehaviour
This is an example of quick and simple UI for interfacing with the BroadcastController.  It is a persistent component which allows you to control the broadcast between scenes.  This UI is not fit for a released game.  

####ChatGUI Monobehaviour
This is an example of a quick and simple UI for interfacing with the ChatController.  It is a persistent component which allows you to control chat state between scenes.  A chat message can be sent by first typing the chat message in the ChatGUI inspector field then clicking Send Message in the game UI (you won't be able to do this in a built game).  Currently, ChatGUI depends on the BroadcastController being initialized to function.  

####KeepAlive Monobehaviour
A simple component which configures the GameObject to be persistent and not be unloaded between scenes.  

####TwitchSceneConfigurator Monobehaviour
A simple component which hooks up the configured cameras to the RenderTextureResizer instance during Start() and unhooks them during OnDestroy().  

##FAQ

**Also see the [FAQ](https://github.com/twitchtv/sdk-dist/wiki/Twitch-Broadcasting-SDK-Integration-Guide#faq) in the general SDK guide.**

####Why am I getting DllNotFoundException when calling functions on BroadcastController/ChatController?  
If you receive the following error in the console when running in the editor: DllNotFoundException: C:/blah/unity/Assets/Plugins/x86/twitchsdk.dll then you probably have forgotten to put the dependency libraries in Assets/Plugins/__platform__.  See "General Editor Setup".  

####Why am I all of a sudden getting a bunch of errors from BroadcastController/ChatController?  Stopping and restarting the game just gives me an TTV_EC_ALREADY_INITIALIZED error.  
Make sure you don't modify the source code of any of the Twitch components while the game is running in the editor.  If you do so then BroadcastController/ChatController may be recompiled on the fly and lose their internal state.  When this happens the state will be out of sync with the native library and the components will likely begin spitting out errors.  If this happens you will need to restart Unity to force the native library to be unloaded and reloaded.

####Why is my broadcast choppy or frozen?  
If the broadcast on the website seems to be stuttery try the following:  
- Make sure you've configured "Maximum Allowed Timestep" properly.  See "BroadcastController/UnityBroadcastController Monobehaviour".  
- Try using a lower bitrate or resolution depending on how you've prepared the VideoParams for the broadcast.  

####Why does it take a long time for the BroadcastStopped event to be fired from BroadcastController?  
This may be because you were trying to broadcast with settings that were too high for your internet connection and the local network is getting backed up with frames.  This is likely being accompanied with a TTV_WRN_FRAMES_QUEUEING warning and maybe even an TTV_EC_FRAME_QUEUE_TOO_LONG which forced the broadcast to terminate.  You should still eventually have your BroadcastStopped being called.  
