﻿using System;
using System.Collections.Generic;
using Twitch;
using Twitch.Chat;
using ErrorCode = Twitch.ErrorCode;

namespace Twitch.Chat
{
    public class WinFormsChatController : ChatController
    {
        #region Memeber Variables

        protected string m_ClientId = "";
        protected string m_ClientSecret = "";
        protected EmoticonMode m_EmoticonMode = EmoticonMode.None;
        protected int m_MessageFlushInterval = 500;
        protected int m_UserListUpdateInterval = 10 * 60 * 1000;

        #endregion

        #region Properties

        public override string ClientId
        {
            get { return m_ClientId; }
            set { m_ClientId = value; }
        }

        public override string ClientSecret
        {
            get { return m_ClientSecret; }
            set { m_ClientSecret = value; }
        }

        public override EmoticonMode EmoticonParsingMode
        {
            get { return m_EmoticonMode; }
            set { m_EmoticonMode = value; }
        }

        public override int MessageFlushInterval
        {
            get { return m_MessageFlushInterval; }
            set
            {
                value = Math.Min(MAX_INTERVAL_MS, Math.Max(value, MIN_INTERVAL_MS));

                m_MessageFlushInterval = value;
                base.MessageFlushInterval = value;
            }
        }

        public override int UserListUpdateInterval
        {
            get { return m_UserListUpdateInterval; }
            set
            {
                value = Math.Min(MAX_INTERVAL_MS, Math.Max(value, MIN_INTERVAL_MS));

                m_UserListUpdateInterval = value;
                base.UserListUpdateInterval = value;
            }
        }
        
        #endregion

        public WinFormsChatController()
        {
            m_CoreApi = CoreApi.Instance;

            if (m_CoreApi == null)
            {
                m_CoreApi = new StandardCoreApi();
            }

            m_ChatApi = new StandardChatApi();
        }

        #region Error Handling

        protected override void CheckError(ErrorCode err)
        {
            if (err != ErrorCode.TTV_EC_SUCCESS)
            {
            }
        }

        protected override void ReportError(string err)
        {
        }

        protected override void ReportWarning(string err)
        {
        }

        #endregion
    }
}
