#include "sdktester.h"
#include <chrono>
#include <unistd.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/select.h>
#include <termios.h>
#include <sys/ioctl.h>
#include <CoreGraphics/CoreGraphics.h>
#include <TargetConditionals.h>

#if TTV_PLATFORM_IOS
#import <UIKit/UIKit.h>
#import "OpenALAudioController.h"
#endif

extern "C" void TTV_SetOutputFileName(const wchar_t*);

void SetOutputFileName(const std::string& filename)
{
#if TTV_PLATFORM_IOS
	NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
	NSString *docs_dir = [paths objectAtIndex:0];
	const char* dir = [docs_dir cStringUsingEncoding:NSASCIIStringEncoding];
	char fullPath[256];
	sprintf(fullPath, "%s/%s", dir, filename.c_str());
	std::string s(fullPath);
	TTV_SetOutputFileName(std::wstring(s.begin(), s.end()).c_str());
#else
	const std::wstring outputFilename (filename.begin(), filename.end());
	TTV_SetOutputFileName(outputFilename.c_str());
#endif
}

std::wstring GetIntelDllPath()
{
	return L"";
}

// Scaling function copied from here: http://www.gotow.net/creative/wordpress/?p=7
//
static CGImageRef CreateScaledCGImageFromCGImage(CGImageRef image, uint32_t width, uint32_t height)
{		
	int bitmapBytesPerRow   = (width * 4);

	CGColorSpaceRef colorspace = CGImageGetColorSpace(image);
	CGContextRef context = CGBitmapContextCreate (NULL,width,height,8,bitmapBytesPerRow,
									 colorspace,kCGImageAlphaNoneSkipFirst);
		
	if (context == NULL)
		return nil;
	
	CGContextDrawImage(context, CGRectMake(0,0,width, height), image);
	
	CGImageRef imgRef = CGBitmapContextCreateImage(context);
	CGContextRelease(context);
	
	return imgRef;
}

void GenerateBGRAFrame(uint8_t* buffer, int width, int height)
{
#if SCREEN_CAPTURE && !TTV_PLATFORM_IOS
	
	CGImageRef image = CGDisplayCreateImage(CGMainDisplayID());
	
	CGImageRef scaledImage = CreateScaledCGImageFromCGImage(image, width, height);
	CGImageRelease(image);
	
	CFDataRef imageData = CGDataProviderCopyData(CGImageGetDataProvider(scaledImage));
	CGImageRelease(scaledImage);
			
	CFDataGetBytes(imageData, CFRangeMake(0, CFDataGetLength(imageData)), buffer);
	CFRelease(imageData);

#else
	
	static int i = 0;
	
	const int kPixelBytes = 4;
	
	// Every 10 frames switch between red and green
	unsigned char R = (i % 30 < 10) ? 0xFF : 0x00;
	unsigned char G = (i % 30 >= 10 && i % 30 < 20) ? 0xFF : 0x00;
	unsigned char B = (i % 30 > 20) ? 0xFF : 0x00;
	unsigned char A = 0x00;
	
	for (int y = 0; y < height; ++y)
	{
		for (int x = 0; x < width; ++x)
		{
			buffer[y*width*kPixelBytes + x*kPixelBytes + 0] = B;
			buffer[y*width*kPixelBytes + x*kPixelBytes + 1] = G;
			buffer[y*width*kPixelBytes + x*kPixelBytes + 2] = R;
			buffer[y*width*kPixelBytes + x*kPixelBytes + 3] = A;
		}
	}
	++i;
	
	ThreadSleep(30);
		
#endif
}

void ThreadSleep(uint32_t ms)
{
	usleep(ms * 1000);
}


void* AllocCallback(size_t size, size_t alignment)
{
	void* ptr = NULL;
	int ret = posix_memalign(&ptr, alignment, size);
	if (ret != 0)
	{
		ptr = NULL;
	}
	return ptr;
}

void FreeCallback(void* ptr)
{
	free(ptr);
}

using std::chrono::steady_clock;

uint64_t GetSystemClockFrequency()
{
    return steady_clock::period::den / steady_clock::period::num;
}

uint64_t GetSystemClockTime()
{
    steady_clock::duration curTime = steady_clock::now().time_since_epoch();
    return curTime.count();
}

uint64_t SystemTimeToMs(uint64_t sysTime)
{
	return sysTime * 1000 / GetSystemClockFrequency();
}

// http://www.flipcode.com/archives/_kbhit_for_Linux.shtml
int _kbhit() 
{
#if !TTV_PLATFORM_IOS
	static const int STDIN = 0;
	static bool initialized = false;

	if (! initialized) 
	{
		// Use termios to turn off line buffering
		termios term;
		tcgetattr(STDIN, &term);
		term.c_lflag &= ~ICANON;
		tcsetattr(STDIN, TCSANOW, &term);
		setbuf(stdin, NULL);
		initialized = true;
	}

	int bytesWaiting;
	ioctl(STDIN, FIONREAD, &bytesWaiting);
	return bytesWaiting;
#else
	return 0;
#endif
}

void StartAudioPlayback()
{
#if TTV_PLATFORM_IOS
	[[OpenALAudioController sharedAudioController] startPlayback];
#endif
}

void StopAudioPlayback()
{
#if TTV_PLATFORM_IOS
	[[OpenALAudioController sharedAudioController] stopPlayback];
#endif
}

void ConfigureAudioCapture()
{
#if TTV_PLATFORM_IOS
	[[OpenALAudioController sharedAudioController] prepareForCapture];
#endif
}

void StartAudioCapture()
{
#if TTV_PLATFORM_IOS
	[[OpenALAudioController sharedAudioController] startCapture];
#endif
}

void StopAudioCapture()
{
#if TTV_PLATFORM_IOS
	[[OpenALAudioController sharedAudioController] stopCapture];
#endif
}

void SubmitAudioSamples()
{
#if TTV_PLATFORM_IOS
	TTV_ErrorCode ret;
	ALint availableFrames = [[OpenALAudioController sharedAudioController] captureFrames];
	if (availableFrames)
	{
		const int16_t *buffer = static_cast<const int16_t*>([OpenALAudioController sharedAudioController].sampleBuffer);
		ret = TTV_SubmitAudioSamples(buffer, static_cast<uint>(availableFrames * 2));
		assert(TTV_SUCCEEDED(ret));
	}
#endif
}

