
#import "AppDelegate.h"
#import "main.h"
#include <AudioToolbox/AudioToolbox.h>

@implementation AppDelegate
@synthesize window;

- (void)dealloc
{
	[window release];
    [super dealloc];
}

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
	AudioSessionInitialize(NULL, kCFRunLoopDefaultMode, NULL, self);
	UInt32 category = kAudioSessionCategory_PlayAndRecord;
	AudioSessionSetProperty(kAudioSessionProperty_AudioCategory,
							sizeof(category),
							&category);
	AudioSessionSetActive(true);
    self.window = [[[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]] autorelease];
    [self.window makeKeyAndVisible];

	InitializeWebcam();
	
	[NSThread detachNewThreadSelector:@selector(start) toTarget:self withObject:nil];
	
    return YES;
}


- (void)start
{
	@autoreleasepool {
		StartStream();
	}
}

@end
