#ifndef SDKTESTER_H
#define SDKTESTER_H

#include "twitchsdktypes.h"

#ifdef TTV_PLATFORM_WINDOWS
#	define SCREEN_CAPTURE 1
	const TTV_PixelFormat kScreenCapturePixelFormat = TTV_PF_BGRA;
#elif TTV_PLATFORM_MAC
#	define SCREEN_CAPTURE 1
	const TTV_PixelFormat kScreenCapturePixelFormat = TTV_PF_ARGB;
#elif TTV_PLATFORM_IOS
#	define WEBCAM_CAPTURE 1
#endif

#include "twitchsdk.h"
#include <string>

void SetOutputFileName(const std::string& filename);
TTV_VideoEncoder GetDefaultVideoEncoder();
std::wstring GetIntelDllPath();
void GenerateBGRAFrame(uint8_t* buffer, int width, int height);
void ThreadSleep(uint32_t ms);
void StartAudioPlayback();
void StopAudioPlayback();
void ConfigureAudioCapture();
void StartAudioCapture();
void StopAudioCapture();
void SubmitAudioSamples();

void* AllocCallback(size_t size, size_t alignment);
void FreeCallback(void* ptr);

// Copied from sysclock.h in the sdk (these are not exported from the SDK)
uint64_t GetSystemClockFrequency();
uint64_t GetSystemClockTime();
uint64_t SystemTimeToMs(uint64_t sysTime);

#if !TTV_PLATFORM_WINDOWS
int _kbhit();
#endif

// Define snprintf on Windows
#if TTV_PLATFORM_WINDOWS
#	define snprintf _snprintf
#endif

#endif	// SDKTESTER_H
