/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTVSDK_TESTS_FIXTURES_CHAT_H
#define TTVSDK_TESTS_FIXTURES_CHAT_H

#include "twitch_asserts.h"
#include "twitchsdk.h"
#include "twitchchat.h"
#include "gtest/gtest.h"


class ChatBasicTest : public testing::Test 
{
protected:
	void SetUp();
	void TearDown();
};


struct ChatScriptTestParams
{
	const utf8char* username;
	const utf8char* channel;
	const utf8char* authtoken;
	const utf8char* script;

	ChatScriptTestParams(const utf8char* username, const utf8char* channel, const utf8char* authtoken, const utf8char* script);
};


class ChatScriptTest : public testing::TestWithParam<ChatScriptTestParams> 
{
protected:
	TTV_ErrorCode res;
	bool testComplete;
	bool testPassed;
	bool coreInitialized;
	bool chatInitialized;

	static void TestFailureCallback(const char* msg, const char* file, int line, void* userdata);
	static void TestFinishedCallback(void* userdata);
	
	void SetUp();
	void RunScript(const std::string& scriptPath);
	void TearDown();
};

#endif
