/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTVSDK_TESTS_FIXTURES_CORE_H
#define TTVSDK_TESTS_FIXTURES_CORE_H

#include "twitch_asserts.h"

class CoreInitializeTest : public testing::Test {
protected:
	TTV_ErrorCode res;

	void SetUp()
	{
		// if a test leaves a result that matches TTV_SUCCEEDED in res,
		// the cleanup function will call TTV_Shutdown.
		res = TTV_EC_SUCCESS;
	}
	void TearDown()
	{
		if (TTV_SUCCEEDED(res))
		{
			TTV_Shutdown();
		}
	}
};

class EncoderTest : public testing::TestWithParam<TTV_VideoEncoder> {
protected:
	TTV_ErrorCode res;

	void SetUp()
	{
		res = TTV_Init(nullptr, "testsuite", nullptr);
		ASSERT_TTV_SUCCEEDED(res);
	}
	void TearDown()
	{
		TTV_Shutdown();
	}
};

#endif
