/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTVSDK_TESTS_TWITCH_ASSERTS_H
#define TTVSDK_TESTS_TWITCH_ASSERTS_H

#define ASSERT_TTV_FAILED(err) {\
	if (TTV_SUCCEEDED(err))\
		FAIL() << "Expected failure in " #err ", got success instead";\
}
#define ASSERT_TTV_FAILED_WITH(err, code) {\
	if (TTV_SUCCEEDED(err))\
		FAIL() << "Expected failure " << code << " (" << TTV_ErrorToString(code) << ") in " #err ", got success instead";\
	else if (err != code)\
		FAIL() << "Expected failure " << code << " (" << TTV_ErrorToString(code) << ") in " #err ", but got " << err << " (" << TTV_ErrorToString(err) << ")";\
}
#define ASSERT_TTV_SUCCEEDED(err) {\
	if (TTV_FAILED(err))\
		FAIL() << "Expected success in " #err ", got failure number " << err << " (" << TTV_ErrorToString(err) << ")";\
}

#endif