/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#include "fixtures/chatfixture.h"
#include "twitch_asserts.h"
#include "twitchsdk.h"
#include "twitchchat.h"
#include "targa.h"

// NOTE: This class doesn't work anymore

// TODO: this timing code is Windows-specific and should be made more generic when we move the tests to other platforms
#include <windows.h>

namespace
{
	uint64_t GetSystemClockFrequency()
	{	
		//Todo: This is a race condition waiting to happen, 64bit values are not atomic
		static uint64_t frequency = 0;
		if (frequency == 0)
		{
			auto qpfIsValid = QueryPerformanceFrequency( reinterpret_cast<LARGE_INTEGER*>(&frequency) );
			assert(qpfIsValid);
		}

		assert (frequency > 0);
		return frequency;
	}

	uint64_t SystemTimeToMs(uint64_t sysTime)
	{
		return sysTime * 1000 / GetSystemClockFrequency();
	}

	uint64_t GetSystemClockTimeMs()
	{
		uint64_t counter;
		(void)QueryPerformanceCounter( reinterpret_cast<LARGE_INTEGER*>(&counter) );
		return SystemTimeToMs(counter);
	}

	void ChatAPI_SetTestFailureCallback();
}


void ChatBasicTest::SetUp()
{
	TTV_ErrorCode ec = TTV_Init(nullptr, "<client_id>", L"");
	ASSERT_TTV_SUCCEEDED(ec);
}

void ChatBasicTest::TearDown()
{
	TTV_ErrorCode ec = TTV_Shutdown();
	ASSERT_TTV_SUCCEEDED(ec);
}


ChatScriptTestParams::ChatScriptTestParams(const utf8char* username, const utf8char* channel, const utf8char* authtoken, const utf8char* script)
{
	ChatScriptTestParams::username = username;
	ChatScriptTestParams::channel = channel;
	ChatScriptTestParams::authtoken = authtoken;
	ChatScriptTestParams::script = script;
}


void ChatScriptTest::TestFailureCallback(const char* msg, const char* file, int line, void* userdata)
{
	ChatScriptTest* test = reinterpret_cast<ChatScriptTest*>(userdata);
	test->testPassed = false;
	FAIL() << "Test failed at " << file << ":" << line << " - " << msg;
}

void ChatScriptTest::TestFinishedCallback(void* userdata)
{
	ChatScriptTest* test = reinterpret_cast<ChatScriptTest*>(userdata);
	test->testComplete = true;
}
	

void ChatScriptTest::SetUp()
{
	testComplete = false;
	testPassed = true;
	coreInitialized = false;
	chatInitialized = false;

	//ChatAPI_SetTestFailureCallback(TestFailureCallback, this);
	//ChatAPI_SetTestFinishedCallback(TestFinishedCallback, this);

	const ChatScriptTestParams& params = GetParam();

	res = TTV_Init(nullptr, "testsuite", nullptr);
	ASSERT_TTV_SUCCEEDED(res);

	coreInitialized = TTV_SUCCEEDED(res);
}


void ChatScriptTest::RunScript(const std::string& scriptPath)
{
	const ChatScriptTestParams& params = GetParam();

	//ChatAPI_UseTestTransport(scriptPath.c_str());

	TTV_ErrorCode err = TTV_Chat_Init(TTV_CHAT_TOKENIZATION_OPTION_NONE, nullptr, nullptr);
	ASSERT_TTV_SUCCEEDED(err);

	chatInitialized = TTV_SUCCEEDED(err);

	const uint64_t kTimeout = 1000 * 30;
	uint64_t startTime = GetSystemClockTimeMs();

	while (!testComplete)
	{
		if (GetSystemClockTimeMs() - startTime > kTimeout)
		{
			FAIL() << "Test hung";
			break;
		}

		err = TTV_Chat_FlushEvents();
		ASSERT_TTV_SUCCEEDED(err);
	}

	if (chatInitialized)
	{
		err = TTV_Chat_Shutdown(nullptr, nullptr);
		ASSERT_TTV_SUCCEEDED(err);

		chatInitialized = false;
	}

	// check the success of the test
	if (!testPassed)
	{
		FAIL();
	}
}


void ChatScriptTest::TearDown()
{
	if (chatInitialized)
	{
		TTV_ErrorCode err = TTV_Chat_Shutdown(nullptr, nullptr);
		ASSERT_TTV_SUCCEEDED(err);
	}

	if (coreInitialized)
	{
		TTV_ErrorCode err = TTV_Shutdown();
		ASSERT_TTV_SUCCEEDED(err);
	}

	//ChatAPI_SetTestFailureCallback(nullptr, nullptr);
	//ChatAPI_SetTestFinishedCallback(nullptr, nullptr);
}
