/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#include "gtest/gtest.h"
#include "twitch_asserts.h"
#include "fixtures/chatfixture.h"

// Simple Tests

void ChatInitShutdownCallback(TTV_ErrorCode error, void* userdata)
{
	ASSERT_TTV_SUCCEEDED(error);

	bool* done = static_cast<bool*>(userdata);
	*done = true;
}

TEST_F(ChatBasicTest, SynchronousInitAndShutdown)
{
	TTV_ErrorCode ec = TTV_Chat_Init(TTV_CHAT_TOKENIZATION_OPTION_NONE, nullptr, nullptr);
	ASSERT_TTV_SUCCEEDED(ec);

	ec = TTV_Chat_Shutdown(nullptr, nullptr);
	ASSERT_TTV_SUCCEEDED(ec);
}

TEST_F(ChatBasicTest, AsynchronousInitAndShutdown)
{
	bool done = false;
	TTV_ErrorCode ec = TTV_Chat_Init(TTV_CHAT_TOKENIZATION_OPTION_NONE, ChatInitShutdownCallback, &done);
	ASSERT_TTV_SUCCEEDED(ec);

	while (!done)
	{
		ec = TTV_Chat_FlushEvents();
		ASSERT_TTV_SUCCEEDED(ec);
	}

	done = false;
	ec = TTV_Chat_Shutdown(ChatInitShutdownCallback, &done);
	ASSERT_TTV_SUCCEEDED(ec);

	while (!done)
	{
		ec = TTV_Chat_FlushEvents();
		ASSERT_TTV_SUCCEEDED(ec);
	}
}


// Script Tests

TEST_P(ChatScriptTest, ScriptRunner)
{
	const ChatScriptTestParams& params = GetParam();

	RunScript(params.script);
}
