/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#include "gtest/gtest.h"
#include "twitchsdk.h"
#include "twitch_asserts.h"
#include "fixtures/core.h"

TEST_F(CoreInitializeTest, CoreInit)
{
	res = TTV_Init(nullptr, "testsuite", nullptr);
	ASSERT_TTV_SUCCEEDED(res);
}
TEST_F(CoreInitializeTest, CoreInitializeTwice)
{
	res = TTV_Init(nullptr, "testsuite", nullptr);
	ASSERT_TTV_SUCCEEDED(res);

	res = TTV_Init(nullptr, "testsuite", nullptr);
	ASSERT_TTV_FAILED_WITH(res, TTV_EC_ALREADY_INITIALIZED);

	res = TTV_Shutdown();
	ASSERT_TTV_SUCCEEDED(res);

	res = TTV_Shutdown();
	ASSERT_TTV_FAILED_WITH(res, TTV_EC_NOT_INITIALIZED);
}
TEST_F(CoreInitializeTest, CoreFailsWithNullClientId)
{
	res = TTV_Init(nullptr, nullptr, nullptr);
	ASSERT_TTV_FAILED_WITH(res, TTV_EC_INVALID_CLIENTID);
}
TEST_F(CoreInitializeTest, CoreFailsWithEmptyClientId)
{
	res = TTV_Init(nullptr, "", nullptr);
	ASSERT_TTV_FAILED_WITH(res, TTV_EC_INVALID_CLIENTID);
}
TEST_F(CoreInitializeTest, CoreInvalidMemCallbacksStruct)
{
	TTV_MemCallbacks callbacks;
	memset(&callbacks, 0, sizeof(callbacks));

	res = TTV_Init(&callbacks, "testsuite", nullptr);
	ASSERT_TTV_FAILED_WITH(res, TTV_EC_INVALID_STRUCT_SIZE);
}
