/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#include "gtest/gtest.h"
#include "twitchsdk.h"
#include "twitch_asserts.h"
#include "fixtures/encoder.h"

TEST_P(EncoderInitializeTest, StreamWithDefaults)
{
	res = TTV_Init(nullptr, "testsuite", nullptr);
	ASSERT_TTV_SUCCEEDED(res);
	coreInitialized = TTV_SUCCEEDED(res);
}


INSTANTIATE_TEST_CASE_P(main, EncoderInitializeTest, testing::Values(TTV_VID_ENC_DEFAULT));
