##########################################################################################################
#
# Fragment: chat_cx
# 
# Optional settings: None
#
##########################################################################################################

import glob
import os
import build_types

def load_twitchsdk_fragment(primitives, options):

    # NOTE: The auto-generated C++/CX code is compiled into the SDK so it is added here

    fragment = build_types.SourceFragment('twitchsdk', 'chat_cx', os.path.dirname(os.path.realpath(__file__)))

    # Add source
    # files = fragment.glob_source_files( os.path.join(fragment.root_path, 'source', '*.cpp') )
    # fragment.add_source_group("Source Files/chat/cx", files)

    files = fragment.glob_source_files( os.path.join(fragment.root_path, 'bindings', 'source', 'twitch', 'chat', '*.cpp') )
    fragment.add_source_group("Source Files/chat/cx/bindings/twitch", files)

    files = fragment.glob_source_files( os.path.join(fragment.root_path, 'bindings', 'source', 'ttv', 'binding', 'cx', '*.cpp') )
    fragment.add_source_group("Source Files/chat/cx/bindings/ttv/binding/cx", files)

    #files = fragment.glob_source_files( os.path.join(fragment.root_path, 'tests', 'unit', 'source', '*.cpp') )
    #fragment.add_source_group("Source Files/chat/cx/test", files)

    # Add headers
    # files = fragment.glob_header_files( os.path.join(fragment.root_path, 'include', 'twitchsdk', 'chat', '*.h') )
    # fragment.add_source_group("Header Files/chat/cx", files)

    files = fragment.glob_header_files( os.path.join(fragment.root_path, 'bindings', 'include', 'twitch', 'chat', '*.h') )
    fragment.add_source_group("Header Files/chat/cx/bindings/twitch", files)

    files = fragment.glob_header_files( os.path.join(fragment.root_path, 'bindings', 'include', 'ttv', 'binding', 'cx', '*.h') )
    fragment.add_source_group("Header Files/chat/cx/bindings/ttv/binding/cx", files)

    #files = fragment.glob_source_files( os.path.join(fragment.root_path, 'tests', 'unit', 'include', 'twitchsdk', chat', '*.h') )
    #fragment.add_source_group("Header Files/chat/cx/test", files)

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'bindings/include') )

    # Export symbols
    #fragment.add_symbol_export_files( os.path.join(fragment.root_path, 'source', 'exports.txt') )

    return fragment
