/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#pragma once

#include "twitchsdk/chat/chatapi.h"

#if TTV_PLATFORM_MAC
#define EXPORT_API __attribute__((visibility("default")))
#else
#define EXPORT_API
#endif

namespace ttv
{
	namespace chat
	{
		struct TTV_ChatKeyValuePair
		{
			char key[64];
			char value[192];
		};

		struct TTV_ChatKeyValuePairList
		{
			TTV_ChatKeyValuePair* list;
			uint32_t count;
		};
	
		struct ManagedChatAPIListener
		{
		public:
			void FireInitializationCallback(TTV_ErrorCode result);
			void FireShutdownCallback(TTV_ErrorCode result);
			void FireUserEmoticonSetsChangedCallback(const TTV_ChatUserEmoticonSets* emoticonSets);
			void FireEmoticonSetDataCallback(const TTV_ChatEmoticonSetData* emoticonSet);
			void FireUserBlockChangeCallback(const std::string& userName, const std::string& blockUsername, bool block, TTV_ErrorCode ec);

// TODO: revisit how to split this into separate files
#if !TTV_PLATFORM_UNITYIOS
		private:
			typedef void (*TTV_CSharp_ChatInitializationCallback) (TTV_ErrorCode error);
			typedef void (*TTV_CSharp_ChatShutdownCallback) (TTV_ErrorCode error);
			typedef void (*TTV_CSharp_ChatUserEmoticonSetsChangedCallback) (const TTV_ChatUserEmoticonSets* emoticonSets);
			typedef void (*TTV_CSharp_ChatEmoticonSetDataCallback) (const TTV_ChatEmoticonSetData* emoticonSet);
			typedef void (*TTV_CSharp_ChatUserBlockChangeCallback) (const utf8char* userName, const utf8char* blockUsername, bool block, TTV_ErrorCode ec);

			TTV_CSharp_ChatInitializationCallback initializationCallback;
			TTV_CSharp_ChatShutdownCallback shutdownCallback;
			TTV_CSharp_ChatUserEmoticonSetsChangedCallback userEmoticonSetsChangedCallback;
			TTV_CSharp_ChatEmoticonSetDataCallback emoticonSetDataCallback;
			TTV_CSharp_ChatUserBlockChangeCallback userBlockChangeCallback;
#endif
		};

		struct ManagedChatChannelListener
		{
		public:
			void FireChannelStateChangedCallback(const std::string& channelName, TTV_ChatChannelState state, TTV_ErrorCode ec);
			void FireChannelInfoChangedCallback(const std::string& channelName, const TTV_ChatChannelInfo& info);
			void FireChannelLocalUserChangedCallback(const std::string& channelName, const TTV_ChatUserInfo& userInfo);
			void FireChannelUserChangeCallback(const std::string& channelName, const TTV_ChatUserList* joinList, const TTV_ChatUserList* leaveList, const TTV_ChatUserList* infoChangeList);
			void FireChannelMessageCallback(const std::string& channelName, const TTV_ChatMessageList* messageList);
			void FireChannelClearCallback(const std::string& channelName, const std::string& username);
			void FireChannelBadgeDataDownloadCallback(const std::string& channelName, TTV_ErrorCode result);
			void FireChannelHostTargetChangedCallback(const std::string& channelName, const std::string& targetChannel, uint32_t numViewers);
			void FireChannelNoticeCallback(const std::string& channelName, const std::string& id, const std::map<std::string, std::string>& params);
			void FireChannelSetBroadcasterLanguageCallback(const std::string& channelName, TTV_ErrorCode ec);

// TODO: revisit how to split this into separate files
#if !TTV_PLATFORM_UNITYIOS
		private:
			typedef void (*TTV_CSharp_ChatChannelStateChangedCallback) (const utf8char* channelName, TTV_ChatChannelState state, TTV_ErrorCode ec);
			typedef void (*TTV_CSharp_ChatChannelInfoChangedCallback) (const utf8char* channelName, const TTV_ChatChannelInfo* info);
			typedef void (*TTV_CSharp_ChatChannelLocalUserChangedCallback) (const utf8char* channelName, const TTV_ChatUserInfo* userInfo);
			typedef void (*TTV_CSharp_ChatChannelUserChangeCallback) (const utf8char* channelName, const TTV_ChatUserList* joinList, const TTV_ChatUserList* leaveList, const TTV_ChatUserList* infoChangeList);
			typedef void (*TTV_CSharp_ChatChannelMessageCallback) (const utf8char* channelName, const TTV_ChatMessageList* messageList);
			typedef void (*TTV_CSharp_ChatClearCallback) (const utf8char* channelName, const utf8char* username);
			typedef void (*TTV_CSharp_BadgeDataDownloadCallback) (const utf8char* channelName, TTV_ErrorCode error);
			typedef void (*TTV_CSharp_HostTargetChangedCallback) (const utf8char* channelName, const utf8char* targetChannel, uint32_t numViewers);
			typedef void (*TTV_CSharp_NoticeCallback) (const utf8char* channelName, const utf8char* id, const TTV_ChatKeyValuePairList* params);
			typedef void (*TTV_CSharp_SetBroadcasterLanguageCallback) (const utf8char* channelName, TTV_ErrorCode ec);

			TTV_CSharp_ChatChannelStateChangedCallback channelStateChangedCallback;
			TTV_CSharp_ChatChannelInfoChangedCallback channelInfoChangedCallback;
			TTV_CSharp_ChatChannelLocalUserChangedCallback localUserChangedCallback;
			TTV_CSharp_ChatChannelUserChangeCallback userCallback;
			TTV_CSharp_ChatChannelMessageCallback messageCallback;
			TTV_CSharp_ChatClearCallback clearCallback;
			TTV_CSharp_BadgeDataDownloadCallback badgeDownloadCallback;
			TTV_CSharp_HostTargetChangedCallback hostTargetChangedCallback;
			TTV_CSharp_NoticeCallback noticeCallback;
			TTV_CSharp_SetBroadcasterLanguageCallback setBroadcasterLanguageCallback;
#endif
		};
	}
}
