/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/internal/bindings/csharp/csharp_chat.h"
#include "twitchsdk/core/stringutilities.h"
#include "twitchsdk/chat/internal/ircstring.h"

#if !TTV_PLATFORM_UNITYIOS

void ttv::chat::ManagedChatAPIListener::FireInitializationCallback(TTV_ErrorCode result)
{
	if (initializationCallback != nullptr)
	{
		initializationCallback(result);
	}
}

void ttv::chat::ManagedChatAPIListener::FireShutdownCallback(TTV_ErrorCode result)
{
	if (shutdownCallback != nullptr)
	{
		shutdownCallback(result);
	}
}

void ttv::chat::ManagedChatAPIListener::FireUserEmoticonSetsChangedCallback(const TTV_ChatUserEmoticonSets* emoticonSets)
{
	if (userEmoticonSetsChangedCallback != nullptr)
	{
		userEmoticonSetsChangedCallback(emoticonSets);
	}
}

void ttv::chat::ManagedChatAPIListener::FireEmoticonSetDataCallback(const TTV_ChatEmoticonSetData* emoticonSet)
{
	if (emoticonSetDataCallback != nullptr)
	{
		emoticonSetDataCallback(emoticonSet);
	}
}

void ttv::chat::ManagedChatAPIListener::FireUserBlockChangeCallback(const std::string& userName, const std::string& blockUsername, bool block, TTV_ErrorCode ec)
{
	if (userBlockChangeCallback != nullptr)
	{
		userBlockChangeCallback(userName.c_str(), blockUsername.c_str(), block, ec);
	}
}

void ttv::chat::ManagedChatChannelListener::FireChannelStateChangedCallback(const std::string& channelName, TTV_ChatChannelState state, TTV_ErrorCode ec)
{
	if (channelStateChangedCallback != nullptr)
	{
		channelStateChangedCallback(channelName.c_str(), state, ec);
	}
}

void ttv::chat::ManagedChatChannelListener::FireChannelInfoChangedCallback(const std::string& channelName, const TTV_ChatChannelInfo& info)
{
	if (channelInfoChangedCallback != nullptr)
	{
		channelInfoChangedCallback(channelName.c_str(), &info);
	}
}

void ttv::chat::ManagedChatChannelListener::FireChannelLocalUserChangedCallback(const std::string& channelName, const TTV_ChatUserInfo& userInfo)
{
	if (localUserChangedCallback != nullptr)
	{
		localUserChangedCallback(channelName.c_str(), &userInfo);
	}
}

void ttv::chat::ManagedChatChannelListener::FireChannelUserChangeCallback(const std::string& channelName, const TTV_ChatUserList* joinList, const TTV_ChatUserList* leaveList, const TTV_ChatUserList* infoChangeList)
{
	if (userCallback != nullptr)
	{
		userCallback(channelName.c_str(), joinList, leaveList, infoChangeList);
	}
}

void ttv::chat::ManagedChatChannelListener::FireChannelMessageCallback(const std::string& channelName, const TTV_ChatMessageList* messageList)
{
	if (messageCallback != nullptr)
	{
		messageCallback(channelName.c_str(), messageList);
	}
}

void ttv::chat::ManagedChatChannelListener::FireChannelClearCallback(const std::string& channelName, const std::string& username)
{
	if (clearCallback != nullptr)
	{
		clearCallback(channelName.c_str(), username.c_str());
	}
}

void ttv::chat::ManagedChatChannelListener::FireChannelBadgeDataDownloadCallback(const std::string& channelName, TTV_ErrorCode result)
{
	if (badgeDownloadCallback != nullptr)
	{
		badgeDownloadCallback(channelName.c_str(), result);
	}
}

void ttv::chat::ManagedChatChannelListener::FireChannelHostTargetChangedCallback(const std::string& channelName, const std::string& targetChannel, uint32_t numViewers)
{
	if (hostTargetChangedCallback != nullptr)
	{
		hostTargetChangedCallback(channelName.c_str(), targetChannel.c_str(), numViewers);
	}
}

void ttv::chat::ManagedChatChannelListener::FireChannelNoticeCallback(const std::string& channelName, const std::string& id, const std::map<std::string, std::string>& params)
{
	if (noticeCallback != nullptr)
	{
		std::vector<TTV_ChatKeyValuePair> arr;
		arr.resize(params.size());

		TTV_ChatKeyValuePairList kvpList;

		int index = 0;
		for (auto kvp : params)
		{
			TTV_ChatKeyValuePair& pair = arr[index];
			SafeStringCopy(pair.key, kvp.first.c_str(), sizeof(pair.key));
			SafeStringCopy(pair.value, kvp.second.c_str(), sizeof(pair.value));
			++index;
		}

		kvpList.list = arr.data();
		kvpList.count = static_cast<uint32_t>(arr.size());

		noticeCallback(channelName.c_str(), id.c_str(), &kvpList);
	}
}

void ttv::chat::ManagedChatChannelListener::FireChannelSetBroadcasterLanguageCallback(const std::string& channelName, TTV_ErrorCode ec)
{
	if (setBroadcasterLanguageCallback != nullptr)
	{
		setBroadcasterLanguageCallback(channelName.c_str(), ec);
	}
}

#endif
