##########################################################################################################
#
# Fragment: core_cx
# 
# Optional settings: None
#
##########################################################################################################

import glob
import os
import build_types

def load_twitchsdk_fragment(primitives, options):

    # NOTE: The auto-generated C++/CX code is compiled into the SDK so it is added here

    fragment = build_types.SourceFragment('twitchsdk', 'core_cx', os.path.dirname(os.path.realpath(__file__)))

    # Add source
    files = fragment.glob_source_files( os.path.join(fragment.root_path, 'source', '*.cpp') )
    fragment.add_source_group("Source Files/core/cx", files)

    files = fragment.glob_source_files( os.path.join(fragment.root_path, 'bindings', 'source', 'twitch', '*.cpp') )
    fragment.add_source_group("Source Files/core/cx/bindings/twitch", files)

    files = fragment.glob_source_files( os.path.join(fragment.root_path, 'bindings', 'source', 'ttv', 'binding', 'cx', '*.cpp') )
    fragment.add_source_group("Source Files/core/cx/bindings/ttv/binding/cx", files)

    #files = fragment.glob_source_files( os.path.join(fragment.root_path, 'tests', 'unit', 'source', '*.cpp') )
    #fragment.add_source_group("Source Files/core/cx/test", files)

    # Add headers
    files = fragment.glob_header_files( os.path.join(fragment.root_path, 'include', 'twitchsdk', 'core', '*.h') )
    fragment.add_source_group("Header Files/core/cx", files)

    files = fragment.glob_header_files( os.path.join(fragment.root_path, 'bindings', 'include', 'twitch', '*.h') )
    fragment.add_source_group("Header Files/core/cx/bindings/twitch", files)

    files = fragment.glob_header_files( os.path.join(fragment.root_path, 'bindings', 'include', 'ttv', 'binding', 'cx', '*.h') )
    fragment.add_source_group("Header Files/core/cx/bindings/ttv/binding/cx", files)

    #files = fragment.glob_source_files( os.path.join(fragment.root_path, 'tests', 'unit', 'include', 'core', '*.h') )
    #fragment.add_source_group("Header Files/core/cx/test", files)

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'bindings/include') )

    # Export symbols
    #fragment.add_symbol_export_files( os.path.join(fragment.root_path, 'source', 'exports.txt') )

    return fragment
