#pragma once

#include "twitchsdk/core/types/coretypes.h"
#include "twitchsdk/core/types/errortypes.h"
#include "twitchsdk/core/httprequest.h"
#include <collection.h>
#include <codecvt>
#include <memory>
#include <string>
#include <vector>
#include <map>

#include "twitch/ErrorCode.h"
#include "twitch/HttpParam.h"
#include "twitch/HttpRequestType.h"


namespace ttv
{
	namespace binding
	{
		namespace cx
		{
			class CxHttpRequest;
		}
	}
}

namespace Twitch
{
	interface class IHttpRequestProvider;
	ref struct HttpRequestResult;
}


public ref struct ::Twitch::HttpRequestResult sealed
{
	property ::Platform::Array<::Twitch::HttpParam^>^ headers;
	property uint statusCode;
	property ::Platform::String^ body;
};


public interface class ::Twitch::IHttpRequestProvider
{
	::Twitch::ErrorCode SendHttpRequest(
		::Platform::String^ url,
		const ::Platform::Array<::Twitch::HttpParam^>^ headerParams,
		::Platform::String^ requestBody,
		::Twitch::HttpRequestType httpReqType,
		uint timeOutInSecs,
		::Twitch::HttpRequestResult^* result
	);
};


class ::ttv::binding::cx::CxHttpRequest : public ::ttv::HttpRequest
{
public:
	CxHttpRequest(::Twitch::IHttpRequestProvider^ bindingImpl);

	virtual TTV_ErrorCode SendHttpRequest(
		const std::string& url,
		const std::vector<HttpParam>& requestHeaders,
		const std::string& requestBody,
		HttpRequestType httpReqType,
		uint timeOutInSecs,
		HttpRequestHeadersCallback headersCallback,
		HttpRequestCallback responseCallback,
		void* userData) override;

private:
	::Twitch::IHttpRequestProvider^ mBindingImpl;
};
