#pragma once

#include "twitchsdk/core/cx_httprequest.h"
#include "twitchsdk/core/cx_socket.h"
#include "twitch/ErrorCode.h"
#include "twitch/MessageLevel.h"
#include <codecvt>
#include <string>
#include <memory>



namespace Twitch
{
	ref class Library;
}


public ref class ::Twitch::Library sealed
{
public:
	ErrorCode InitializeLibrary();
	void SetClientId(::Platform::String^ clientId);
	void SetHttpRequestProvider(::Twitch::IHttpRequestProvider^ provider);
	ErrorCode RegisterSocketFactory(::Twitch::ISocketFactory^ factory);
	ErrorCode UnregisterSocketFactory(::Twitch::ISocketFactory^ factory);
	ErrorCode RegisterWebSocketFactory(::Twitch::IWebSocketFactory^ factory);
	ErrorCode UnregisterWebSocketFactory(::Twitch::IWebSocketFactory^ factory);
	ErrorCode SetComponentMessageLevel(::Platform::String^ component, ::Twitch::MessageLevel level);
	ErrorCode GetComponentMessageLevel(::Platform::String^ component, ::Twitch::MessageLevel* level);
	ErrorCode SetGlobalMessageLevel(::Twitch::MessageLevel level);
	ErrorCode GetGlobalMessageLevel(::Twitch::MessageLevel* level);
	ErrorCode ShutdownLibrary();
	::Platform::String^ GetVersionString();

private:
	std::vector<std::shared_ptr<::ttv::binding::cx::CxSocketFactory>> mSocketFactories;
	std::vector<std::shared_ptr<::ttv::binding::cx::CxWebSocketFactory>> mWebSocketFactories;
};
