#pragma once

#include "twitchsdk/core/cx_httprequest.h"
#include "twitch/ErrorCode.h"
#include "twitch/WebSocketMessageType.h"
#include <codecvt>
#include <string>



namespace ttv
{
	namespace binding
	{
		namespace cx
		{
			class CxSocketBase;
			class CxSocket;
			class CxWebSocket;
			class CxSocketFactory;
			class CxWebSocketFactory;
		}
	}
}

namespace Twitch
{
	interface class ISocket;
	interface class ISocketFactory;
	interface class IWebSocket;
	interface class IWebSocketFactory;
}


public interface class ::Twitch::ISocket
{
	ErrorCode Connect();
	ErrorCode Disconnect();

	ErrorCode Send(const ::Platform::Array<uint8>^ buffer, uint length, uint* numSent);
	ErrorCode Recv(::Platform::Array<uint8>^* buffer, uint length, uint* numReceived);

	uint64 TotalSent();
	uint64 TotalReceived();

	bool Connected();
};


public interface class ::Twitch::ISocketFactory
{
	bool IsProtocolSupported(::Platform::String^ protocol);
	ErrorCode CreateSocket(::Platform::String^ uri, ISocket^* result);
};


public interface class ::Twitch::IWebSocket
{
	ErrorCode Connect();
	ErrorCode Disconnect();
	ErrorCode Send(WebSocketMessageType type, const ::Platform::Array<uint8>^ buffer, uint length);
	ErrorCode Recv(WebSocketMessageType* type, ::Platform::Array<uint8>^* buffer, uint length, uint* numReceived);
	ErrorCode Peek(WebSocketMessageType* type, uint* length);
	bool Connected();
};


public interface class ::Twitch::IWebSocketFactory
{
	bool IsProtocolSupported(::Platform::String^ protocol);
	ErrorCode CreateWebSocket(::Platform::String^ uri, IWebSocket^* result);
};


class ttv::binding::cx::CxSocketBase
{
protected:
	CxSocketBase();

	void EnsureSendBufferSize(size_t size);

	::Platform::Array<uint8>^ mSendBuffer; // The recycled buffer used to send data.
};


class ttv::binding::cx::CxSocket : public ttv::ISocket, public CxSocketBase
{
public:
	CxSocket(::Twitch::ISocket^ socket);

	::Twitch::ISocket^ GetImplementation() { return mBindingImpl; }

	// ISocket implementation
	virtual TTV_ErrorCode Connect() override;
	virtual TTV_ErrorCode Disconnect() override;
	virtual TTV_ErrorCode Send(const uint8_t* buffer, size_t length, size_t& sent) override;
	virtual TTV_ErrorCode Recv(uint8_t* buffer, size_t length, size_t& received) override;
	virtual uint64_t TotalSent() override;
	virtual uint64_t TotalReceived() override;
	virtual bool Connected() override;

private:
	::Twitch::ISocket^ mBindingImpl;
};


class ttv::binding::cx::CxSocketFactory : public ttv::ISocketFactory
{
public:
	CxSocketFactory(::Twitch::ISocketFactory^ factory);

	::Twitch::ISocketFactory^ GetImplementation() { return mBindingImpl; }

	// ISocketFactory implementation
	virtual bool IsProtocolSupported(const std::string& protocol) override;
	virtual TTV_ErrorCode CreateSocket(const std::string& uri, std::shared_ptr<ISocket>& result) override;

private:
	::Twitch::ISocketFactory^ mBindingImpl;
};


class ttv::binding::cx::CxWebSocket : public ttv::IWebSocket, public CxSocketBase
{
public:
	CxWebSocket(::Twitch::IWebSocket^ socket);

	::Twitch::IWebSocket^ GetImplementation() { return mBindingImpl; }

	// IWebSocket implementation
	virtual TTV_ErrorCode Connect() override;
	virtual TTV_ErrorCode Disconnect() override;
	virtual TTV_ErrorCode Send(MessageType type, const uint8_t* buffer, size_t length) override;
	virtual TTV_ErrorCode Recv(MessageType& type, uint8_t* buffer, size_t length, size_t& received) override;
	virtual TTV_ErrorCode Peek(MessageType& type, size_t& length) override;
	virtual bool Connected() override;

private:
	::Twitch::IWebSocket^ mBindingImpl;
};


class ttv::binding::cx::CxWebSocketFactory : public ttv::IWebSocketFactory
{
public:
	CxWebSocketFactory(::Twitch::IWebSocketFactory^ factory);

	::Twitch::IWebSocketFactory^ GetImplementation() { return mBindingImpl; }

	// IWebSocketFactory implementation
	virtual bool IsProtocolSupported(const std::string& protocol) override;
	virtual TTV_ErrorCode CreateWebSocket(const std::string& uri, std::shared_ptr<IWebSocket>& result) override;

private:
	::Twitch::IWebSocketFactory^ mBindingImpl;
};
