#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/cx_coreutil.h"
#include <vccorlib.h>

void ttv::binding::cx::ToBinding(const char* const * val, Platform::String^* result)
{
	if (result != nullptr)
	{
		if (val == nullptr || *val == nullptr)
		{
			*result = nullptr;
		}
		else
		{
			std::wstring_convert<std::codecvt_utf8_utf16<wchar_t>> converter;
			*result = ref new Platform::String(converter.from_bytes(*val).c_str());
		}
	}
}


void ttv::binding::cx::ToBinding(const char* const * val, size_t length, Platform::String^* result)
{
	if (result != nullptr)
	{
		if (val == nullptr || *val == nullptr)
		{
			*result = nullptr;
		}
		else
		{
			auto first = *val;
			auto last = *val + length;
			std::wstring_convert<std::codecvt_utf8_utf16<wchar_t>> converter;
			*result = ref new Platform::String(converter.from_bytes(first, last).c_str());
		}
	}
}


void ttv::binding::cx::ToNative(Platform::String^* val, ::std::string* result)
{
	if (result != nullptr)
	{
		if (val == nullptr || *val == nullptr)
		{
			*result = "";
		}
		else
		{
			std::wstring_convert<std::codecvt_utf8_utf16<wchar_t>> converter;
			*result = converter.to_bytes((*val)->Data());
		}
	}
}


void ttv::binding::cx::ToBinding(const::std::string* val, Platform::String^* result)
{
	if (result != nullptr)
	{
		if (val == nullptr)
		{
			*result = nullptr;
		}
		else
		{
			std::wstring_convert<std::codecvt_utf8_utf16<wchar_t>> converter;
			*result = ref new Platform::String(converter.from_bytes(*val).c_str());
		}
	}
}


void ttv::binding::cx::ToBinding(const::std::string* val, Platform::String^** result)
{
	if (result != nullptr)
	{
		ToBinding(val, *result);
	}
}
