#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/cx_coreutil.h"
#include "twitchsdk/core/cx_library.h"
#include "twitchsdk/core/coreapi.h"
#include "twitchsdk.h"

using namespace ttv::binding::cx;


::Twitch::ErrorCode Twitch::Library::InitializeLibrary()
{
	TTV_ErrorCode ec = TTV_InitializeLibrary();

	::Twitch::ErrorCode bindingErrorCode;
	ToBinding(&ec, &bindingErrorCode);

	return bindingErrorCode;
}


void Twitch::Library::SetClientId(::Platform::String^ clientId)
{
	::std::string nativeClientId;
	ToNative(clientId, &nativeClientId);
	::ttv::SetClientId(nativeClientId);
}


void Twitch::Library::SetHttpRequestProvider(::Twitch::IHttpRequestProvider^ provider)
{
	std::shared_ptr<CxHttpRequest> proxy;
	if (provider != nullptr)
	{
		proxy = std::make_shared<CxHttpRequest>(provider);
	}

	::ttv::SetHttpRequest(proxy);
}


::Twitch::ErrorCode Twitch::Library::RegisterSocketFactory(::Twitch::ISocketFactory^ factory)
{
	if (factory == nullptr)
	{
		return ::Twitch::ErrorCode::TTV_EC_INVALID_ARG;
	}

	auto iter = std::find_if(mSocketFactories.begin(), mSocketFactories.end(), [factory](std::shared_ptr<CxSocketFactory> x)
	{
		return x->GetImplementation() == factory;
	});

	if (iter != mSocketFactories.end())
	{
		return ::Twitch::ErrorCode::TTV_EC_INVALID_ARG;
	}

	auto wrapper = std::make_shared<CxSocketFactory>(factory);

	TTV_ErrorCode ec = ttv::RegisterSocketFactory(wrapper);

	if (TTV_SUCCEEDED(ec))
	{
		mSocketFactories.push_back(wrapper);
	}

	::Twitch::ErrorCode bindingErrorCode;
	ToBinding(&ec, &bindingErrorCode);

	return bindingErrorCode;
}


::Twitch::ErrorCode Twitch::Library::UnregisterSocketFactory(::Twitch::ISocketFactory^ factory)
{
	if (factory == nullptr)
	{
		return ::Twitch::ErrorCode::TTV_EC_INVALID_ARG;
	}

	auto iter = std::find_if(mSocketFactories.begin(), mSocketFactories.end(), [factory](std::shared_ptr<CxSocketFactory> x)
	{
		return x->GetImplementation() == factory;
	});

	if (iter == mSocketFactories.end())
	{
		return ::Twitch::ErrorCode::TTV_EC_INVALID_ARG;
	}

	auto wrapper = *iter;
	TTV_ErrorCode ec = ttv::UnregisterSocketFactory(wrapper);

	if (TTV_SUCCEEDED(ec))
	{
		mSocketFactories.erase(iter);
	}

	::Twitch::ErrorCode bindingErrorCode;
	ToBinding(&ec, &bindingErrorCode);

	return bindingErrorCode;
}


::Twitch::ErrorCode Twitch::Library::RegisterWebSocketFactory(::Twitch::IWebSocketFactory^ factory)
{
	if (factory == nullptr)
	{
		return ::Twitch::ErrorCode::TTV_EC_INVALID_ARG;
	}

	auto iter = std::find_if(mWebSocketFactories.begin(), mWebSocketFactories.end(), [factory](std::shared_ptr<CxWebSocketFactory> x)
	{
		return x->GetImplementation() == factory;
	});

	if (iter != mWebSocketFactories.end())
	{
		return ::Twitch::ErrorCode::TTV_EC_INVALID_ARG;
	}

	auto wrapper = std::make_shared<CxWebSocketFactory>(factory);

	TTV_ErrorCode ec = ttv::RegisterWebSocketFactory(wrapper);

	if (TTV_SUCCEEDED(ec))
	{
		mWebSocketFactories.push_back(wrapper);
	}

	::Twitch::ErrorCode bindingErrorCode;
	ToBinding(&ec, &bindingErrorCode);

	return bindingErrorCode;
}


::Twitch::ErrorCode Twitch::Library::UnregisterWebSocketFactory(::Twitch::IWebSocketFactory^ factory)
{
	if (factory == nullptr)
	{
		return ::Twitch::ErrorCode::TTV_EC_INVALID_ARG;
	}

	auto iter = std::find_if(mWebSocketFactories.begin(), mWebSocketFactories.end(), [factory](std::shared_ptr<CxWebSocketFactory> x)
	{
		return x->GetImplementation() == factory;
	});

	if (iter == mWebSocketFactories.end())
	{
		return ::Twitch::ErrorCode::TTV_EC_INVALID_ARG;
	}

	auto wrapper = *iter;
	TTV_ErrorCode ec = ttv::UnregisterWebSocketFactory(wrapper);

	if (TTV_SUCCEEDED(ec))
	{
		mWebSocketFactories.erase(iter);
	}

	::Twitch::ErrorCode bindingErrorCode;
	ToBinding(&ec, &bindingErrorCode);

	return bindingErrorCode;
}


::Twitch::ErrorCode Twitch::Library::SetComponentMessageLevel(::Platform::String^ component, ::Twitch::MessageLevel level)
{
	::std::string nativeComponent;
	ToNative(component, &nativeComponent);

	TTV_MessageLevel nativeLevel;
	ToNative(&level, &nativeLevel);

	TTV_ErrorCode ec = ::ttv::trace::SetComponentMessageLevel(nativeComponent.c_str(), nativeLevel);

	::Twitch::ErrorCode bindingErrorCode;
	ToBinding(&ec, &bindingErrorCode);
	return bindingErrorCode;
}


::Twitch::ErrorCode Twitch::Library::GetComponentMessageLevel(::Platform::String^ component, ::Twitch::MessageLevel* level)
{
	::std::string nativeComponent;
	ToNative(component, &nativeComponent);

	TTV_MessageLevel nativeLevel = TTV_ML_NONE;
	TTV_ErrorCode ec = ::ttv::trace::GetComponentMessageLevel(nativeComponent.c_str(), nativeLevel);

	if (level != nullptr)
	{
		ToBinding(&nativeLevel, level);
	}

	::Twitch::ErrorCode bindingErrorCode;
	ToBinding(&ec, &bindingErrorCode);
	return bindingErrorCode;
}


::Twitch::ErrorCode Twitch::Library::SetGlobalMessageLevel(::Twitch::MessageLevel level)
{
	TTV_MessageLevel nativeLevel;
	ToNative(&level, &nativeLevel);

	TTV_ErrorCode ec = ::ttv::trace::SetGlobalMessageLevel(nativeLevel);

	::Twitch::ErrorCode bindingErrorCode;
	ToBinding(&ec, &bindingErrorCode);
	return bindingErrorCode;
}


::Twitch::ErrorCode Twitch::Library::GetGlobalMessageLevel(::Twitch::MessageLevel* level)
{
	TTV_MessageLevel nativeLevel = TTV_ML_NONE;
	TTV_ErrorCode ec = ::ttv::trace::GetGlobalMessageLevel(nativeLevel);

	if (level != nullptr)
	{
		ToBinding(&nativeLevel, level);
	}

	::Twitch::ErrorCode bindingErrorCode;
	ToBinding(&ec, &bindingErrorCode);
	return bindingErrorCode;
}


::Twitch::ErrorCode Twitch::Library::ShutdownLibrary()
{
	TTV_ErrorCode ec = TTV_ShutdownLibrary();

	::Twitch::ErrorCode bindingErrorCode;
	ToBinding(&ec, &bindingErrorCode);

	return bindingErrorCode;
}


::Platform::String^ Twitch::Library::GetVersionString()
{
	auto nativeVersionString = TTV_GetVersionString();

	::Platform::String^ bindingVersionString;
	ToBinding(&nativeVersionString, &bindingVersionString);

	return bindingVersionString;
}
