/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/types/errortypes.h"

#if TTV_PLATFORM_MAC
#define EXPORT_API __attribute__((visibility("default")))
#else
#define EXPORT_API
#endif

extern "C" EXPORT_API const char* TTV_CSharp_Core_ErrorToString(TTV_ErrorCode err)
{
	return ttv::ErrorToString(err);
}


extern "C" EXPORT_API TTV_ErrorCode TTV_CSharp_Core_SetTraceLevel(TTV_MessageLevel traceLevel)
{
	return ttv::trace::SetGlobalMessageLevel(traceLevel);
}


extern "C" EXPORT_API TTV_ErrorCode TTV_CSharp_Core_SetTraceChannelLevel(const char* channel, TTV_MessageLevel traceLevel)
{
	return ttv::trace::SetComponentMessageLevel(channel, traceLevel);
}


extern "C" EXPORT_API TTV_ErrorCode TTV_CSharp_Core_SetTraceOutput(const wchar_t* outputFileName)
{
	return ttv::trace::SetOutputFile(outputFileName);
}


extern "C" EXPORT_API TTV_ErrorCode TTV_CSharp_Core_SetHttpRequestProvider()
{
	// TODO: Figure out C# HttpRequestProvider if needed
	return TTV_EC_UNIMPLEMENTED;
}
