#pragma once

// <<INCLUDES_START>>
#include "twitch/tracking/TrackingAPI.h"
#include "twitchsdk/tracking/trackingapilistener.h"
#include <memory>
// <<INCLUDES_END>>

// <<FORWARD_DECLARATIONS_START>>
namespace Twitch
{
    interface class IModule;
    interface class IModuleListener;
    namespace Tracking
    {
        interface class ITrackingAPIListener;
    }
}

namespace ttv
{
    namespace binding
    {
        namespace cx
        {
            class ITrackingAPIListenerAdapter;
        }
    }
}

// <<FORWARD_DECLARATIONS_END>>

class ::ttv::binding::cx::ITrackingAPIListenerAdapter : public ::ttv::tracking::ITrackingAPIListener
{
    // <<CONSTRUCTOR_START>>
    public: ITrackingAPIListenerAdapter(Twitch::Tracking::ITrackingAPIListener^ impl, Twitch::Tracking::TrackingAPI^ trackingApi);
    // <<CONSTRUCTOR_END>>

    // <<METHODS_START>>
    public: virtual void ModuleStateChanged(::ttv::IModule * source, ::ttv::IModule::State state, ::TTV_ErrorCode ec) override;
    public: virtual void TrackingEventFlushCompleted(::uint32_t batchStartId, ::uint32_t batchEndId, ::std::string const & serverUrl, ::TTV_ErrorCode ec) override;
    public: virtual void TrackingEventsDiscarded(::uint32_t batchStartId, ::uint32_t batchEndId) override;
    public: Twitch::Tracking::ITrackingAPIListener^ GetBindingImpl() { return mBindingImpl; }
    // <<METHODS_END>>

private:
    // <<FIELDS_START>>
    Twitch::Tracking::ITrackingAPIListener^ mBindingImpl;
    Twitch::Tracking::TrackingAPI^ mTrackingAPI;
    // <<FIELDS_END>>
};
