#pragma once

// <<INCLUDES_START>>
#include "twitchsdk/tracking/internal/pch.h"
#include "twitch/ErrorCode.h"
#include "twitch/IModule.h"
#include "twitch/IModuleListener.h"
#include "twitch/ModuleState.h"
// <<INCLUDES_END>>

// <<FORWARD_DECLARATIONS_START>>
namespace Twitch
{
    interface class IModule;
    interface class IModuleListener;
    namespace Tracking
    {
        interface class ITrackingAPIListener;
    }
}

// <<FORWARD_DECLARATIONS_END>>

namespace Twitch
{
    namespace Tracking
    {
        public interface class ITrackingAPIListener: public Twitch::IModuleListener
        {
            // <<METHODS_START>>
            void TrackingEventFlushCompleted(uint32 batchStartId, uint32 batchEndId, Platform::String^ serverUrl, Twitch::ErrorCode ec);
            void TrackingEventsDiscarded(uint32 batchStartId, uint32 batchEndId);
            // <<METHODS_END>>
        };
    }
}
