#pragma once

// <<INCLUDES_START>>
#include "twitch/CoreAPI.h"
#include "twitch/CorePubSubState.h"
#include "twitch/ErrorCode.h"
#include "twitch/ICoreAPIListener.h"
#include "twitch/IModule.h"
#include "twitch/ModuleState.h"
#include "twitch/UserInfo.h"
#include "twitch/UserInfoList.h"
#include "twitch/tracking/ITrackingAPIListener.h"
#include "twitchsdk/tracking/trackingapi.h"
#include <collection.h>
#include <memory>
// <<INCLUDES_END>>

// <<FORWARD_DECLARATIONS_START>>
namespace Twitch
{
    namespace Tracking
    {
        ref class TrackingAPI;
    }
}

namespace ttv
{
    namespace binding
    {
        namespace cx
        {
            class ICoreAPIListenerAdapter;
            class ITrackingAPIListenerAdapter;
        }
    }
}

// <<FORWARD_DECLARATIONS_END>>

public ref class Twitch::Tracking::TrackingAPI sealed : public Twitch::IModule
{
    // <<CONSTRUCTOR_START>>
    public: TrackingAPI();
    // <<CONSTRUCTOR_END>>

    // <<METHODS_START>>
    public: virtual Twitch::ModuleState GetState();
    public: virtual Platform::String^ GetModuleName();
    public: virtual Twitch::ErrorCode Initialize();
    public: virtual Twitch::ErrorCode Shutdown();
    public: virtual Twitch::ErrorCode Update();
    public: Twitch::ErrorCode TrackEvent(Platform::String^ eventName, Windows::Foundation::Collections::IMapView<Platform::String^, Platform::String^>^ params, uint32* eventId);
    public: Twitch::ErrorCode FlushEvents();
    public: Twitch::ErrorCode SetCoreApi(Twitch::CoreAPI^ coreApi);
    public: Twitch::ErrorCode SetMixpanelToken(Platform::String^ mixpanelToken);
    public: Twitch::ErrorCode SetMaxEventsInBatch(uint32 batchSize);
    public: Twitch::ErrorCode SetMaxBytesInBatch(uint32 batchSize);
    public: Twitch::ErrorCode SetFlushIntervalInMs(uint32 flushInterval);
    public: Twitch::ErrorCode SetListener(Twitch::Tracking::ITrackingAPIListener^ listener);
    internal: std::shared_ptr<::ttv::tracking::TrackingAPI> GetTrackingApi() { return mTrackingAPI; }
    // <<METHODS_END>>

private:
    // <<FIELDS_START>>
    std::shared_ptr<::ttv::binding::cx::ITrackingAPIListenerAdapter> mTrackingApiListener;
    ::std::shared_ptr<::ttv::tracking::TrackingAPI> mTrackingAPI;
    // <<FIELDS_END>>
};
