// <<INCLUDES_START>>
#include "twitchsdk/tracking/internal/pch.h"
#include "ttv/binding/cx/ITrackingAPIListenerAdapter.h"
#include "twitch/tracking/ITrackingAPIListener.h"
#include "twitchsdk/core/cx_coreutil.h"
// <<INCLUDES_END>>

// <<USING_NAMESPACE_START>>
using namespace ttv::binding::cx;
// <<USING_NAMESPACE_END>>

// <<CONSTRUCTOR_START>>
ttv::binding::cx::ITrackingAPIListenerAdapter::ITrackingAPIListenerAdapter(Twitch::Tracking::ITrackingAPIListener^ impl, Twitch::Tracking::TrackingAPI^ trackingApi)
: mBindingImpl(impl)
, mTrackingAPI(trackingApi)
{
}
// <<CONSTRUCTOR_END>>

// <<METHODS_START>>
void ::ttv::binding::cx::ITrackingAPIListenerAdapter::ModuleStateChanged(::ttv::IModule * source, ::ttv::IModule::State state, ::TTV_ErrorCode ec)
{
    Twitch::ModuleState _binding_state;
    ToBinding(&state, &_binding_state);
    Twitch::ErrorCode _binding_ec;
    ToBinding(&ec, &_binding_ec);
    mBindingImpl->ModuleStateChanged(mTrackingAPI, _binding_state, _binding_ec);
}

void ::ttv::binding::cx::ITrackingAPIListenerAdapter::TrackingEventFlushCompleted(::uint32_t batchStartId, ::uint32_t batchEndId, ::std::string const & serverUrl, ::TTV_ErrorCode ec)
{
    uint32 _binding_batchStartId;
    ToBinding(&batchStartId, &_binding_batchStartId);

    uint32 _binding_batchEndId;
    ToBinding(&batchEndId, &_binding_batchEndId);

    Platform::String^ _binding_serverUrl;
    ToBinding(&serverUrl, &_binding_serverUrl);

    Twitch::ErrorCode _binding_ec;
    ToBinding(&ec, &_binding_ec);

    mBindingImpl->TrackingEventFlushCompleted(_binding_batchStartId, _binding_batchEndId, _binding_serverUrl, _binding_ec);
}

void ::ttv::binding::cx::ITrackingAPIListenerAdapter::TrackingEventsDiscarded(::uint32_t batchStartId, ::uint32_t batchEndId)
{
    uint32 _binding_batchStartId;
    ToBinding(&batchStartId, &_binding_batchStartId);

    uint32 _binding_batchEndId;
    ToBinding(&batchEndId, &_binding_batchEndId);

    mBindingImpl->TrackingEventsDiscarded(_binding_batchStartId, _binding_batchEndId);
}

// <<METHODS_END>>
