// <<INCLUDES_START>>
#include "twitchsdk/tracking/internal/pch.h"
#include "ttv/binding/cx/ICoreAPIListenerAdapter.h"
#include "ttv/binding/cx/ITrackingAPIListenerAdapter.h"
#include "twitch/CoreAPI.h"
#include "twitch/ICoreAPIListener.h"
#include "twitch/tracking/ITrackingAPIListener.h"
#include "twitch/tracking/TrackingAPI.h"
#include "twitchsdk/core/cx_coreutil.h"
#include <collection.h>
// <<INCLUDES_END>>

// <<USING_NAMESPACE_START>>
using namespace ttv::binding::cx;
// <<USING_NAMESPACE_END>>

// <<CONSTRUCTOR_START>>
Twitch::Tracking::TrackingAPI::TrackingAPI()
{
    mTrackingAPI = std::make_shared<::ttv::tracking::TrackingAPI>();
}
// <<CONSTRUCTOR_END>>

// <<METHODS_START>>
Twitch::ModuleState Twitch::Tracking::TrackingAPI::GetState()
{
    ::ttv::IModule::State _native_return_value = mTrackingAPI->GetState();

    Twitch::ModuleState _binding_return_value;
    ToBinding(&_native_return_value, &_binding_return_value);

    return _binding_return_value;
}

Platform::String^ Twitch::Tracking::TrackingAPI::GetModuleName()
{
    ::std::string _native_return_value = mTrackingAPI->GetModuleName();

    Platform::String^ _binding_return_value;
    ToBinding(&_native_return_value, &_binding_return_value);

    return _binding_return_value;
}

Twitch::ErrorCode Twitch::Tracking::TrackingAPI::Initialize()
{
    ::TTV_ErrorCode _native_return_value = mTrackingAPI->Initialize();

    Twitch::ErrorCode _binding_return_value;
    ToBinding(&_native_return_value, &_binding_return_value);

    return _binding_return_value;
}

Twitch::ErrorCode Twitch::Tracking::TrackingAPI::Shutdown()
{
    ::TTV_ErrorCode _native_return_value = mTrackingAPI->Shutdown();

    Twitch::ErrorCode _binding_return_value;
    ToBinding(&_native_return_value, &_binding_return_value);

    return _binding_return_value;
}

Twitch::ErrorCode Twitch::Tracking::TrackingAPI::Update()
{
    ::TTV_ErrorCode _native_return_value = mTrackingAPI->Update();

    Twitch::ErrorCode _binding_return_value;
    ToBinding(&_native_return_value, &_binding_return_value);

    return _binding_return_value;
}

Twitch::ErrorCode Twitch::Tracking::TrackingAPI::TrackEvent(Platform::String^ eventName, Windows::Foundation::Collections::IMapView<Platform::String^, Platform::String^>^ params, uint32* eventId)
{
    ::std::string _native_eventName;
    ToNative(&eventName, &_native_eventName);

    ::std::map<::std::string, ::std::string> _native_params;
    ToNative(&params, &_native_params);

    ::uint32_t _native_eventId;

    ::TTV_ErrorCode _native_return_value = mTrackingAPI->TrackEvent(_native_eventName, _native_params, _native_eventId);

    ToBinding(&_native_eventId, eventId);

    Twitch::ErrorCode _binding_return_value;
    ToBinding(&_native_return_value, &_binding_return_value);

    return _binding_return_value;
}

Twitch::ErrorCode Twitch::Tracking::TrackingAPI::FlushEvents()
{
    ::TTV_ErrorCode _native_return_value = mTrackingAPI->FlushEvents();

    Twitch::ErrorCode _binding_return_value;
    ToBinding(&_native_return_value, &_binding_return_value);

    return _binding_return_value;
}

Twitch::ErrorCode Twitch::Tracking::TrackingAPI::SetCoreApi(Twitch::CoreAPI^ coreApi)
{
    ::TTV_ErrorCode _native_return_value = mTrackingAPI->SetCoreApi(coreApi->GetCoreApi());
    Twitch::ErrorCode _binding_return_value;
    ToBinding(&_native_return_value, &_binding_return_value);
    return _binding_return_value;
}

Twitch::ErrorCode Twitch::Tracking::TrackingAPI::SetMixpanelToken(Platform::String^ mixpanelToken)
{
    ::std::string _native_mixpanelToken;
    ToNative(&mixpanelToken, &_native_mixpanelToken);

    ::TTV_ErrorCode _native_return_value = mTrackingAPI->SetMixpanelToken(_native_mixpanelToken);


    Twitch::ErrorCode _binding_return_value;
    ToBinding(&_native_return_value, &_binding_return_value);

    return _binding_return_value;
}

Twitch::ErrorCode Twitch::Tracking::TrackingAPI::SetMaxEventsInBatch(uint32 batchSize)
{
    ::uint32_t _native_batchSize;
    ToNative(&batchSize, &_native_batchSize);

    ::TTV_ErrorCode _native_return_value = mTrackingAPI->SetMaxEventsInBatch(_native_batchSize);


    Twitch::ErrorCode _binding_return_value;
    ToBinding(&_native_return_value, &_binding_return_value);

    return _binding_return_value;
}

Twitch::ErrorCode Twitch::Tracking::TrackingAPI::SetMaxBytesInBatch(uint32 batchSize)
{
    ::uint32_t _native_batchSize;
    ToNative(&batchSize, &_native_batchSize);

    ::TTV_ErrorCode _native_return_value = mTrackingAPI->SetMaxBytesInBatch(_native_batchSize);


    Twitch::ErrorCode _binding_return_value;
    ToBinding(&_native_return_value, &_binding_return_value);

    return _binding_return_value;
}

Twitch::ErrorCode Twitch::Tracking::TrackingAPI::SetFlushIntervalInMs(uint32 flushInterval)
{
    ::uint32_t _native_flushInterval;
    ToNative(&flushInterval, &_native_flushInterval);

    ::TTV_ErrorCode _native_return_value = mTrackingAPI->SetFlushIntervalInMs(_native_flushInterval);


    Twitch::ErrorCode _binding_return_value;
    ToBinding(&_native_return_value, &_binding_return_value);

    return _binding_return_value;
}

Twitch::ErrorCode Twitch::Tracking::TrackingAPI::SetListener(Twitch::Tracking::ITrackingAPIListener^ listener)
{
    std::shared_ptr<ttv::binding::cx::ITrackingAPIListenerAdapter> adapter;
    if (listener != nullptr)
    {
        adapter = std::make_shared<ttv::binding::cx::ITrackingAPIListenerAdapter>(listener, this);
    }
    
    ::TTV_ErrorCode _native_return_value = mTrackingAPI->SetListener(adapter);
    
    if (TTV_SUCCEEDED(_native_return_value))
    {
        mTrackingApiListener.reset();
        if (adapter != nullptr)
        {
            mTrackingApiListener = adapter;
        }
    }
    
    Twitch::ErrorCode _binding_return_value;
    ToBinding(&_native_return_value, &_binding_return_value);
    return _binding_return_value;
}

// <<METHODS_END>>
