##########################################################################################################
#
# Fragment: tracking_cx
# 
# Optional settings: None
#
##########################################################################################################

import glob
import os
import build_types

def load_twitchsdk_fragment(primitives, options):

    # NOTE: The auto-generated C++/CX code is compiled into the SDK so it is added here

    fragment = build_types.SourceFragment('twitchsdk', 'tracking_cx', os.path.dirname(os.path.realpath(__file__)))

    # Add source
    #files = fragment.glob_source_files( os.path.join(fragment.root_path, 'source', '*.cpp') )
    #fragment.add_source_group("Source Files/tracking/cx", files)

    files = fragment.glob_source_files( os.path.join(fragment.root_path, 'bindings', 'source', 'twitch', 'tracking', '*.cpp') )
    fragment.add_source_group("Source Files/tracking/cx/bindings/twitch", files)

    files = fragment.glob_source_files( os.path.join(fragment.root_path, 'bindings', 'source', 'ttv', 'binding', 'cx', '*.cpp') )
    fragment.add_source_group("Source Files/tracking/cx/bindings/ttv/binding/cx", files)

    # Add headers
    #files = fragment.glob_header_files( os.path.join(fragment.root_path, 'include', 'twitchsdk', 'tracking', '*.h') )
    #fragment.add_source_group("Header Files/tracking/cx", files)

    files = fragment.glob_header_files( os.path.join(fragment.root_path, 'bindings', 'include', 'twitch', 'tracking', '*.h') )
    fragment.add_source_group("Header Files/tracking/cx/bindings/twitch", files)

    files = fragment.glob_header_files( os.path.join(fragment.root_path, 'bindings', 'include', 'ttv', 'binding', 'cx', '*.h') )
    fragment.add_source_group("Header Files/tracking/cx/bindings/ttv/binding/cx", files)

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'bindings/include') )

    return fragment
