#include "stdafx.h"
#include "../webcam.h"
#include "twitchwebcam.h"
#include "testing.h"

#include <vector>

// Forward declarations
extern "C" TTVSDK_API void TestVideoCaptureSystem_PluginDevice(const utf8char* uniqueId, const utf8char* name, const TTV_WebCamDeviceCapability* capabilities, unsigned int capabilityCount, unsigned int color);
extern "C" TTVSDK_API void TestVideoCaptureSystem_UnplugDevice(unsigned int deviceIndex);
extern "C" TTVSDK_API void WebcamAPI_SetPreferredCaptureSystem(const char* name);
extern "C" TTVSDK_API void WebcamAPI_SetTestSystemParameters(unsigned int numInitialTestDevices, const utf8char** uniqueIds, const utf8char** names, const TTV_WebCamDeviceCapability* capabilities, unsigned int capabilityCount, const unsigned int* colors);


// Static data for test devices
static const utf8char* sUniqueIds[] = 
{
	"Device_0",
	"Device_1",
	"Device_2",
	"Device_3",
};

static const utf8char* sNames[] = 
{
	"TestDevice_Name_0",
	"TestDevice_Name_1",
	"TestDevice_Name_2",
	"TestDevice_Name_3",
};

static TTV_WebCamDeviceCapability sCapabilities[] =
{
	{},
	{},
	{},
	{},
	{},
	{},
};

static const unsigned int sColors[] = 
{
	0xFFFF0000,
	0xFF00FF00,
	0xFF0000FF,
	0xFFCC00CC,
};


extern std::vector< std::shared_ptr<DeviceCaptureData> > gCaptureDevices;


bool IsTestDevicePluggedIn(int id)
{
	for (auto iter = gCaptureDevices.begin(); iter != gCaptureDevices.end(); ++iter)
	{
		std::shared_ptr<DeviceCaptureData> data = *iter;
		if ( strcmp(data->device->uniqueId, sUniqueIds[id]) == 0 ) 
		{
			return true;
		}
	}

	return false;
}


void PluginTestDevice(int id)
{
	if (IsTestDevicePluggedIn(id))
	{
		return;
	}

	TestVideoCaptureSystem_PluginDevice(sUniqueIds[id], sNames[id], sCapabilities, sizeof(sCapabilities)/sizeof(sCapabilities[0]), sColors[id]);
}


void UnplugTestDevice(int id)
{
	if (!IsTestDevicePluggedIn(id))
	{
		return;
	}

	auto iter = FindDeviceData(sUniqueIds[id]);
	auto data = *iter;

	if (data->device != nullptr)
	{
		TestVideoCaptureSystem_UnplugDevice(data->device->deviceIndex);
	}
}


void ToggleDevice(int id)
{
	if (IsTestDevicePluggedIn(id))
	{
		UnplugTestDevice(id);
	}
	else
	{
		PluginTestDevice(id);
	}
}


void SetupTestSystem()
{
	int capabilityIndex = 0;

	sCapabilities[capabilityIndex].frameRate = 20;
	sCapabilities[capabilityIndex].isTopToBottom = capabilityIndex % 2 != 0;
	sCapabilities[capabilityIndex].resolution.width = 640;
	sCapabilities[capabilityIndex].resolution.height = 480;
	sCapabilities[capabilityIndex].format = TTV_WEBCAM_FORMAT_XRGB32;
	sCapabilities[capabilityIndex].isNative = true;
	sCapabilities[capabilityIndex].capabilityIndex = capabilityIndex++;

	sCapabilities[capabilityIndex].frameRate = 20;
	sCapabilities[capabilityIndex].isTopToBottom = capabilityIndex % 2 != 0;
	sCapabilities[capabilityIndex].resolution.width = 640;
	sCapabilities[capabilityIndex].resolution.height = 480;
	sCapabilities[capabilityIndex].format = TTV_WEBCAM_FORMAT_RGB24;
	sCapabilities[capabilityIndex].isNative = true;
	sCapabilities[capabilityIndex].capabilityIndex = capabilityIndex++;

	sCapabilities[capabilityIndex].frameRate = 20;
	sCapabilities[capabilityIndex].isTopToBottom = capabilityIndex % 2 != 0;
	sCapabilities[capabilityIndex].resolution.width = 640;
	sCapabilities[capabilityIndex].resolution.height = 480;
	sCapabilities[capabilityIndex].format = TTV_WEBCAM_FORMAT_ARGB32;
	sCapabilities[capabilityIndex].isNative = true;
	sCapabilities[capabilityIndex].capabilityIndex = capabilityIndex++;

	sCapabilities[capabilityIndex].frameRate = 20;
	sCapabilities[capabilityIndex].isTopToBottom = capabilityIndex % 2 != 0;
	sCapabilities[capabilityIndex].resolution.width = 640;
	sCapabilities[capabilityIndex].resolution.height = 480;
	sCapabilities[capabilityIndex].format = TTV_WEBCAM_FORMAT_RGB555;
	sCapabilities[capabilityIndex].isNative = true;
	sCapabilities[capabilityIndex].capabilityIndex = capabilityIndex++;

	sCapabilities[capabilityIndex].frameRate = 20;
	sCapabilities[capabilityIndex].isTopToBottom = capabilityIndex % 2 != 0;
	sCapabilities[capabilityIndex].resolution.width = 640;
	sCapabilities[capabilityIndex].resolution.height = 480;
	sCapabilities[capabilityIndex].format = TTV_WEBCAM_FORMAT_RGB565;
	sCapabilities[capabilityIndex].isNative = true;
	sCapabilities[capabilityIndex].capabilityIndex = capabilityIndex++;

	sCapabilities[capabilityIndex].frameRate = 20;
	sCapabilities[capabilityIndex].isTopToBottom = capabilityIndex % 2 != 0;
	sCapabilities[capabilityIndex].resolution.width = 640;
	sCapabilities[capabilityIndex].resolution.height = 480;
	sCapabilities[capabilityIndex].format = TTV_WEBCAM_FORMAT_YUY2;
	sCapabilities[capabilityIndex].isNative = true;
	sCapabilities[capabilityIndex].capabilityIndex = capabilityIndex++;

	WebcamAPI_SetPreferredCaptureSystem("TestVideoCaptureSystem");
	WebcamAPI_SetTestSystemParameters(NUM_TEST_VIDEO_CAPTURE_DEVICES, sUniqueIds, sNames, sCapabilities, std::extent<decltype(sCapabilities),0>::value, sColors);
}
