/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTVSDK_WEBCAM_DEVICEMESSAGES_H
#define TTVSDK_WEBCAM_DEVICEMESSAGES_H

#include "twitchwebcam.h"

namespace ttv
{
	namespace cam
	{
		/**
		 * Messages from the main thread to the device thread.
		 */
		namespace DeviceMessageType
		{
			enum Enum
			{
				Invalid = -1,

				Start,
				Stop,
				Initialize,
				Shutdown,

				DeviceCustomMessages		//!< The beginning of the range to be used for custom messages.  These can overlap for different devices without problem.
			};
		}

		struct DeviceMessage
		{
			DeviceMessageType::Enum		type;		//!< The type of message which determines what type to cast it to.
			void*						userdata;	//!< Custom user data.

			DeviceMessage();

			virtual ~DeviceMessage();
		};

		struct StartDeviceMessage : public DeviceMessage
		{
			unsigned int capabilityIndex;
			TTV_WebCamDeviceStatusCallback callback;

			StartDeviceMessage(int ci, TTV_WebCamDeviceStatusCallback cb, void* ud);
		};

		struct StopDeviceMessage : public DeviceMessage
		{
			TTV_WebCamDeviceStatusCallback callback;

			StopDeviceMessage(TTV_WebCamDeviceStatusCallback cb, void* ud);
		};

		struct InitializeDeviceMessage : public DeviceMessage
		{
			unsigned int deviceIndex;

			InitializeDeviceMessage(unsigned int i);
		};

		struct ShutdownDeviceMessage : public DeviceMessage
		{
			ShutdownDeviceMessage();
		};
	}
}

#endif	/* TTVSDK_WEBCAM_DEVICEMESSAGES_H */
