/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTVSDK_IOSVIDEOCAPTUREDEVICE_H
#define TTVSDK_IOSVIDEOCAPTUREDEVICE_H

#include "internal/webcam/videocapturedevice.h"
#include "twitchwebcam.h"
#include "twitchcore/mutex.h"


namespace ttv
{
	namespace cam
	{
		class VideoCaptureSystem;
		class IosVideoCaptureDevice;
	} // namespace cam

} // namespace ttv



/**
 * Proxy Objective-C object for receiving image callbacks from capture devices.  The proxy will forward callbacks 
 * to the owning IosVideoCaptureDevice.
 */
@interface CaptureDeviceProxy : NSObject <AVCaptureVideoDataOutputSampleBufferDelegate>
{
@private
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wobjc-interface-ivars"
	ttv::cam::IosVideoCaptureDevice* mOwner;
#pragma clang diagnostic pop
}

- (void) initializeProxy:(ttv::cam::IosVideoCaptureDevice*)owner;

@end



class ttv::cam::IosVideoCaptureDevice : public ttv::cam::VideoCaptureDevice
{
public:
	
	IosVideoCaptureDevice(ttv::cam::VideoCaptureSystem* parentSystem, AVCaptureDevice* device);

	virtual ~IosVideoCaptureDevice();

	void OnReceivePixelBuffer(CVImageBufferRef pixelBuffer);
	
protected:

	virtual TTV_ErrorCode InitializeDevice(const ttv::cam::InitializeDeviceMessage* message);
	virtual TTV_ErrorCode ShutdownDevice(const ttv::cam::ShutdownDeviceMessage* message);
	virtual TTV_ErrorCode StartDevice(const ttv::cam::StartDeviceMessage* message);
	virtual TTV_ErrorCode StopDevice(const ttv::cam::StopDeviceMessage* message);
	virtual void Update();

private:

	/*lint -e1704*/ // constructor has private access specification
	// This is intentional, as a method to prevent the compiler from generating these
	IosVideoCaptureDevice();
	IosVideoCaptureDevice(const IosVideoCaptureDevice&);
	IosVideoCaptureDevice& operator =(const IosVideoCaptureDevice&);
	/*line -e1704*/
	
	AVCaptureDevice* mNativeDevice;				//!< The native device.
	AVCaptureSession* mCaptureSession;			//!< The component managing video input and output.
	CaptureDeviceProxy* mCaptureDeviceProxy;	//!< The object receiving the callbacks from the device.
	std::vector<NSString*> mNativeCapabilities;	//!< The ordered list of string names of the supported capabilities.
	
};

#endif // defined TTVSDK_IOSVIDEOCAPTUREDEVICE_H
