/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTVSDK_IOSVIDEOCAPTURESYSTEM_H
#define TTVSDK_IOSVIDEOCAPTURESYSTEM_H

#include "internal/webcam/videocapturesystem.h"


namespace ttv
{
	namespace cam
	{
		class IosVideoCaptureSystem;
		class IosVideoCaptureDevice;
	}
} // namespace ttv


class ttv::cam::IosVideoCaptureSystem : public ttv::cam::VideoCaptureSystem
{
public:

	IosVideoCaptureSystem();
	virtual ~IosVideoCaptureSystem();

protected:
	
	virtual TTV_ErrorCode InitializeSystem(const ttv::cam::InitializeSystemMessage* message);
	virtual TTV_ErrorCode ShutdownSystem(const ttv::cam::ShutdownSystemMessage* message);
	virtual void Update();
};

#endif // defined TTVSDK_IOSVIDEOCAPTURESYSTEM_H
