/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTV_CAM_TESTVIDEOCAPTUREDEVICE_H
#define TTV_CAM_TESTVIDEOCAPTUREDEVICE_H

#include "videocapturedevice.h"

namespace ttv
{
	namespace cam
	{
		class TestVideoCaptureDevice;
	}
}


class ttv::cam::TestVideoCaptureDevice : public ttv::cam::VideoCaptureDevice
{
public:
	TestVideoCaptureDevice(VideoCaptureSystem* captureSystem);
	virtual ~TestVideoCaptureDevice();

	void SetTestDeviceData(const utf8char* uniqueId, const utf8char* name, const TTV_WebCamDeviceCapability* capabilities, unsigned int capabilityCount, unsigned int color);

protected:
	virtual TTV_ErrorCode InitializeDevice(const InitializeDeviceMessage* pMessage);
	virtual TTV_ErrorCode ShutdownDevice(const ShutdownDeviceMessage* pMessage);
	virtual TTV_ErrorCode StartDevice(const StartDeviceMessage* pMessage);
	virtual TTV_ErrorCode StopDevice(const StopDeviceMessage* pMessage);
	virtual void Update();

	void CleanupTestDeviceData();

	std::vector<TTV_WebCamDeviceCapability> mTestCapabilities;		//!< The capabilities that are cached until the device is initialized.
	uint64_t mLastCaptureTime;
	unsigned int mBaseColor;
};

#endif // defined TTV_CAM_TESTVIDEOCAPTUREDEVICE_H
