/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTV_CAM_TESTVIDEOCAPTURESYSTEM_H
#define TTV_CAM_TESTVIDEOCAPTURESYSTEM_H

#include "videocapturesystem.h"

namespace ttv
{
	namespace cam
	{
		class TestVideoCaptureSystem;
	}
}


/**
 * 
 */
class ttv::cam::TestVideoCaptureSystem : public ttv::cam::VideoCaptureSystem
{
public:
	TestVideoCaptureSystem();
	virtual ~TestVideoCaptureSystem();

	void SetInitializationParameters(unsigned int numInitialTestDevices, const utf8char** uniqueIds, const utf8char** names, const TTV_WebCamDeviceCapability* capabilities, unsigned int capabilityCount, const unsigned int* colors);
	void PluginDevice(const utf8char* uniqueId, const utf8char* name, const TTV_WebCamDeviceCapability* capabilities, unsigned int capabilityCount, unsigned int color);
	void UnplugDevice(unsigned int deviceIndex);

protected:
	virtual TTV_ErrorCode InitializeSystem(const InitializeSystemMessage* msg);
	virtual TTV_ErrorCode ShutdownSystem(const ShutdownSystemMessage* msg);
	virtual TTV_ErrorCode HandleCustomSystemMessage(std::shared_ptr<cam::SystemMessage> msg);
	virtual void Update();

protected:
	unsigned int mNumInitialTestDevices;
	const utf8char** mTestDeviceUniqueIds;
	const utf8char** mTestDeviceNames;
	const TTV_WebCamDeviceCapability* mCapabilities;
	unsigned int mCapabilityCount;
	const unsigned int* mTestDeviceColors;	
};

#endif // defined TTV_CAM_TESTVIDEOCAPTURESYSTEM_H
