/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTVSDK_WEBCAMFORMAT_H
#define TTVSDK_WEBCAMFORMAT_H

#include "twitchwebcam.h"


namespace ttv
{
	namespace cam
	{
		int GetPixelSize(TTV_WebcamFormat format);
		int GetBufferSize(TTV_WebcamFormat format, int width, int height);

		void GenerateGarbageFrame(TTV_WebCamFrame* frame);

		TTV_ErrorCode ConvertToRGBA(unsigned int width, unsigned int height, TTV_WebcamFormat srcFormat, uint8_t* srcBuffer, uint8_t* destBuffer, unsigned int destPitch);

		TTV_ErrorCode ConvertImageFormat(unsigned int width, unsigned int height, TTV_WebcamFormat srcFormat, uint8_t* srcBuffer, TTV_WebcamFormat destFormat, uint8_t* destBuffer, unsigned int destPitch);
	}
}


#endif	/* TTVSDK_WEBCAMFORMAT_H */
