/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTVSDK_DIRECTSHOWVIDEOCAPTUREDEVICE_H
#define TTVSDK_DIRECTSHOWVIDEOCAPTUREDEVICE_H

#include "internal/webcam/videocapturedevice.h"
#include "twitchwebcam.h"
#include <DShow.h>
#include "internal/webcam/win32/isamplegrabber.h"
#include "twitchcore/mutex.h"
#include "internal/win32/comobjectdeleter.h"
#include "internal/webcam/win32/samplegrabbercallback.h"

namespace ttv
{
namespace cam
{
	class VideoCaptureSystem;
	class DirectShowVideoCaptureDevice;
} // namespace cam
} // namespace ttv

class ttv::cam::DirectShowVideoCaptureDevice : public ttv::cam::VideoCaptureDevice, public std::enable_shared_from_this<ttv::cam::DirectShowVideoCaptureDevice>
{
public:
	
	DirectShowVideoCaptureDevice(ttv::cam::VideoCaptureSystem* parentSystem, std::shared_ptr<IBaseFilter> source, const std::string& name, const std::string& devicePath);

	virtual ~DirectShowVideoCaptureDevice();

	DirectShowVideoCaptureDevice& operator =(DirectShowVideoCaptureDevice&& rhs);

	std::shared_ptr<IBaseFilter> GetSource() { return mSource; }

protected:

	virtual TTV_ErrorCode InitializeDevice(const ttv::cam::InitializeDeviceMessage* message);
	virtual TTV_ErrorCode ShutdownDevice(const ttv::cam::ShutdownDeviceMessage* message);
	virtual TTV_ErrorCode StartDevice(const ttv::cam::StartDeviceMessage* message);
	virtual TTV_ErrorCode StopDevice(const ttv::cam::StopDeviceMessage* message);
	virtual void Update();

	virtual TTV_ErrorCode GetSupportedMediaParameters();

private:

	//lint -save
	//lint -e1704    constructor has private access specification
	// This is intentional, as a method to prevent the compiler from generating these
	DirectShowVideoCaptureDevice();
	DirectShowVideoCaptureDevice(const DirectShowVideoCaptureDevice&);
	DirectShowVideoCaptureDevice& operator =(const DirectShowVideoCaptureDevice&);
	//lint -restore

	std::shared_ptr<IBaseFilter> mSource;

	std::unique_ptr<ICaptureGraphBuilder2, COMObjectDeleter<ICaptureGraphBuilder2>> mCaptureGraphBuilder;
	std::unique_ptr<IGraphBuilder, COMObjectDeleter<IGraphBuilder>> mGraph;
	std::unique_ptr<IMediaControl, COMObjectDeleter<IMediaControl>> mMediaControl;
	std::unique_ptr<IMediaEventEx, COMObjectDeleter<IMediaEventEx>> mEvent;
	std::unique_ptr<ISampleGrabber, COMObjectDeleter<ISampleGrabber>> mSampleGrabber;
	std::unique_ptr<IAMStreamConfig, COMObjectDeleter<IAMStreamConfig>> mStreamConfig;
	SampleGrabberCallback mCallback;

	std::vector<AM_MEDIA_TYPE*> mMediaTypes; //!< The media types which line up with the capabilities list.

	friend class SampleGrabberCallback;

};

#endif // defined TTVSDK_DIRECTSHOWVIDEOCAPTUREDEVICE_H