/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTVSDK_DIRECTSHOWVIDEOCAPTURESYSTEM_H
#define TTVSDK_DIRECTSHOWVIDEOCAPTURESYSTEM_H

#include "internal/webcam/videocapturesystem.h"

struct IBaseFilter;

namespace ttv
{
namespace cam
{
	class DirectShowVideoCaptureSystem;
	class DirectShowVideoCaptureDevice;
} // namespace cam
} // namespace ttv


class ttv::cam::DirectShowVideoCaptureSystem : public ttv::cam::VideoCaptureSystem
{
public:

	DirectShowVideoCaptureSystem();
	virtual ~DirectShowVideoCaptureSystem();

protected:

	virtual TTV_ErrorCode InitializeSystem(const ttv::cam::InitializeSystemMessage* message);
	virtual TTV_ErrorCode ShutdownSystem(const ttv::cam::ShutdownSystemMessage* message);
	virtual void Update();


	struct DirectShowDeviceInfo
	{
		std::shared_ptr<IBaseFilter> camera;
		utf8char uniqueId[kMaxDeviceIdLength+1];
		utf8char name[kMaxDeviceIdLength+1];
	};

	TTV_ErrorCode CheckForDeviceChanges();
	TTV_ErrorCode FindCurrentDevices(std::vector<DirectShowDeviceInfo>& list);

	uint64_t mLastDeviceChangeCheckTime;
};

#endif // defined TTVSDK_DIRECTSHOWVIDEOCAPTURESYSTEM_H