/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTVSDK_ISAMPLEGRABBER_H
#define TTVSDK_ISAMPLEGRABBER_H

// ISampleGrabber is part of DirectShow's editing (as opposed to just playing), which has been deprecated.
// That said, as of the time I write this, all of DirectShow has been deprecated in favor of Media Foundation.
// But DirectShow's editing interfaces are *REALLY* deprecated. More so than the rest of DirectShow.
// The Platform SDK no longer ships with "qedit.h" which defined its interfaces and GUIDs.

// The alternatives to using ISampleGrabber (while still staying with DirectShow to support older OSes) are:
//   1.) use one of the video renderers,
//     which still requires some render destination (and pops up its own window to render to if you don't give one)
//     and also requires a needless round trip to video ram and back, or
//   2.) write your own renderer/filter,
//     which requires an installer to register the separate DLL with COM and significantly more code

// Since ISampleGrabber is still available to use up to Windows 7 (I tested this) and has only had its
// interfaces and GUIDs removed from the Platform SDK, we would have to define them to use them.

// From a higher-up point of view, using something so deprecated is not advised.
// But we need DirectShow for support of all versions of windows below Windows 8.
// (Windows 7 supports Media Foundation but not video capture devices)
// So, essentially we are using the old, deprecated DirectShow for the old, deprecated OSes (where they once were the correct solution).
// An alternative code path will use Media Foundation for newer versions of Windows.

// Reading on this:
// http://social.msdn.microsoft.com/Forums/en-US/windowsdirectshowdevelopment/thread/ac877e2d-80a7-47b6-b315-5e3160b8b219

#include <Unknwn.h>
#include <DShow.h>

struct IMediaSample;

interface ISampleGrabberCB : public IUnknown
{
	virtual STDMETHODIMP SampleCB(double SampleTime, IMediaSample* pSample) = 0;
	virtual STDMETHODIMP BufferCB(double SampleTime, BYTE* pBuffer, long BufferLen) = 0;
};

interface ISampleGrabber : public IUnknown
{
	virtual HRESULT STDMETHODCALLTYPE SetOneShot(BOOL OneShot) = 0;
	virtual HRESULT STDMETHODCALLTYPE SetMediaType(const AM_MEDIA_TYPE* pType) = 0;
	virtual HRESULT STDMETHODCALLTYPE GetConnectedMediaType(AM_MEDIA_TYPE* pType) = 0;
	virtual HRESULT STDMETHODCALLTYPE SetBufferSamples(BOOL BufferThem) = 0;
	virtual HRESULT STDMETHODCALLTYPE GetCurrentBuffer(long* pBufferSize, long* pBuffer) = 0;
	virtual HRESULT STDMETHODCALLTYPE GetCurrentSample(IMediaSample** ppSample) = 0;
	virtual HRESULT STDMETHODCALLTYPE SetCallback(ISampleGrabberCB* pCallback, long WhichMethodToCallback) = 0;
};

static const IID IID_ISampleGrabber = { 0x6B652FFF, 0x11FE, 0x4fce, { 0x92, 0xAD, 0x02, 0x66, 0xB5, 0xD7, 0xC7, 0x8F } };
static const IID IID_ISampleGrabberCB = { 0x0579154A, 0x2B53, 0x4994, { 0xB0, 0xD0, 0xE7, 0x73, 0x14, 0x8E, 0xFF, 0x85 } };
static const CLSID CLSID_SampleGrabber = { 0xC1F400A0, 0x3F08, 0x11d3, { 0x9F, 0x0B, 0x00, 0x60, 0x08, 0x03, 0x9E, 0x37 } };


EXTERN_C const CLSID CLSID_NullRenderer;
#ifdef __cplusplus
	class DECLSPEC_UUID("C1F400A4-3F08-11d3-9F0B-006008039E37")
	NullRenderer;
#endif // defined __cplusplus

#endif // defined TTVSDK_ISAMPLEGRABBER_H