/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTVSDK_SAMPLEGRABBERCALLBACK_H
#define TTVSDK_SAMPLEGRABBERCALLBACK_H

#include "internal/webcam/win32/isamplegrabber.h"

namespace ttv
{
namespace cam
{
	class SampleGrabberCallback;
	class DirectShowVideoCaptureDevice;
} // namespace cam
} // namespace ttv


class ttv::cam::SampleGrabberCallback : public ISampleGrabberCB
{
public:

	void Initialize(const std::weak_ptr<DirectShowVideoCaptureDevice>& that);

private:

	
	virtual STDMETHODIMP QueryInterface(REFIID riid, VOID** ppv);
	virtual STDMETHODIMP_(ULONG) AddRef();
	virtual STDMETHODIMP_(ULONG) Release();

	virtual STDMETHODIMP SampleCB(double SampleTime, IMediaSample* pSample);
	virtual STDMETHODIMP BufferCB(double SampleTime, BYTE* pBuffer, long BufferLen);

	std::weak_ptr<DirectShowVideoCaptureDevice> mThat;

};

#endif // defined TTVSDK_SAMPLEGRABBERCALLBACK_H