/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#ifndef TTVSDK_WEBCAMAPI_H
#define TTVSDK_WEBCAMAPI_H

#include "twitchwebcam.h"


namespace ttv
{
	namespace cam
	{
		class WebcamAPI;
		class VideoCaptureSystem;
	}
}


/**
 * 
 */
class ttv::cam::WebcamAPI
{
public:
	WebcamAPI();
	~WebcamAPI();

	TTV_ErrorCode Init(const TTV_WebCamCallbacks* interruptCallbacks, TTV_WebCamInitializationCallback initCallback, void* userdata);
	TTV_ErrorCode Shutdown(TTV_WebCamShutdownCallback callback, void* userdata);
	TTV_ErrorCode Start(unsigned int deviceIndex, unsigned int capabilityIndex, TTV_WebCamDeviceStatusCallback callback, void* userdata);
	TTV_ErrorCode Stop(unsigned int deviceIndex, TTV_WebCamDeviceStatusCallback callback, void* userdata);
	TTV_ErrorCode FlushEvents();
	TTV_ErrorCode IsFrameAvailable(int deviceIndex, bool* available);
	TTV_ErrorCode GetFrame(int deviceIndex, void* buffer, unsigned int pitch);

private:
	std::shared_ptr<VideoCaptureSystem>	mVideoCaptureSystem;

};

#endif	/* TTVSDK_WEBCAMAPI_H */
