/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#pragma once

#include "twitchcore/types/coretypes.h"

/**
 * The unique module identifier used in error codes.
 */
const uint32_t TTV_MODULE_ID_WEBCAM = 4;


#define TTV_WEBCAM_ERROR_CODES\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_NO_PLATFORM_SUPPORT)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_COULD_NOT_COMPLETE)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_OUT_OF_MEMORY)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_UNKNOWN_ERROR)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_INVALID_PARAMETER)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_INVALID_CAPABILITY)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_BUFFER_NOT_BIG_ENOUGH)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_DEVICE_NOT_STARTED)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_DEVICE_ALREADY_STARTED)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_DEVICE_NOT_FOUND)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_FRAME_NOT_AVAILABLE)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_NOT_INITIALIZED)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_FAILED_TO_START)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_LEFT_IN_UNSAFE_STATE)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_UNSUPPORTED_SOURCE_FORMAT)\
	DEFINE_TTV_ERROR_CODE(TTV_EC_WEBCAM_UNSUPPORTED_TARGET_FORMAT)

/**
 * TTV_WebcamErrorCode - The error codes in use in twitchwebcam.
 */
#define DEFINE_TTV_ERROR_CODE(err) err,
#define DEFINE_TTV_ERROR_CODE_VALUE(err, val) err = val,
typedef enum
{
	TTV_WEBCAM_ERROR_CODES

} TTV_WebcamErrorCode;
#undef DEFINE_TTV_ERROR_CODE
#undef DEFINE_TTV_ERROR_CODE_VALUE
