/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#include "internal/pch.h"
#include "internal/webcam/devicemessages.h"


ttv::cam::DeviceMessage::~DeviceMessage()
{
}


ttv::cam::DeviceMessage::DeviceMessage()
{
	type = DeviceMessageType::Invalid;
	userdata = nullptr;
}


ttv::cam::StartDeviceMessage::StartDeviceMessage(int ci, TTV_WebCamDeviceStatusCallback cb, void* ud) 
{ 
	type = DeviceMessageType::Start;
	capabilityIndex = ci;
	callback = cb;
	userdata = ud;
}


ttv::cam::StopDeviceMessage::StopDeviceMessage(TTV_WebCamDeviceStatusCallback cb, void* ud) 
{ 
	type = DeviceMessageType::Stop;
	callback = cb;
	userdata = ud;
}


ttv::cam::InitializeDeviceMessage::InitializeDeviceMessage(unsigned int i) 
{ 
	type = DeviceMessageType::Initialize;
	deviceIndex = i;
}


ttv::cam::ShutdownDeviceMessage::ShutdownDeviceMessage() 
{ 
	type = DeviceMessageType::Shutdown;
}
