/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#include "internal/pch.h"
#include "internal/webcam/ios/iosvideocapturesystem.h"
#include "internal/webcam/ios/iosvideocapturedevice.h"
#include "twitchcore/sysclock.h"

#import <Foundation/Foundation.h>
#import <CoreMedia/CoreMedia.h>
#import <AVFoundation/AVFoundation.h>


ttv::cam::IosVideoCaptureSystem::IosVideoCaptureSystem()
{
}


ttv::cam::IosVideoCaptureSystem::~IosVideoCaptureSystem()
{
}


TTV_ErrorCode ttv::cam::IosVideoCaptureSystem::InitializeSystem(const ttv::cam::InitializeSystemMessage* /*message*/)
{
	// get all devices in the system which capture video
	NSArray* videoDevices = [AVCaptureDevice devicesWithMediaType:AVMediaTypeVideo];
	
	for (unsigned int i=0; i<videoDevices.count; ++i)
	{
		AVCaptureDevice* nativeDevice = videoDevices[i];
		
		// create the device instance
		auto device = std::make_shared<ttv::cam::IosVideoCaptureDevice>(this, nativeDevice);
		mSystemDevices.push_back(device);
		
		// initialize the device
		device->Initialize(mNextDeviceIndex);
		mNextDeviceIndex++;
	}

	return TTV_EC_SUCCESS;
}


TTV_ErrorCode ttv::cam::IosVideoCaptureSystem::ShutdownSystem(const ttv::cam::ShutdownSystemMessage* /*message*/)
{
	return TTV_EC_SUCCESS;
}


void ttv::cam::IosVideoCaptureSystem::Update()
{
}
