/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#include "internal/pch.h"
#include "internal/webcam/systemmessages.h"



ttv::cam::ClientMessage::~ClientMessage()
{
}


ttv::cam::SystemInitializedClientMessage::SystemInitializedClientMessage(TTV_WebCamInitializationCallback cb, TTV_ErrorCode e, void* ud) 
{ 
	type = ClientMessageType::SystemInitialized;
	err = e;
	callback = cb;
	userdata = ud;
}


ttv::cam::SystemShutdownClientMessage::SystemShutdownClientMessage(TTV_WebCamShutdownCallback cb, void* ud) 
{ 
	type = ClientMessageType::SystemShutdown;
	err = TTV_EC_SUCCESS;
	callback = cb;
	userdata = ud;
}


ttv::cam::DeviceStatusClientMessage::DeviceStatusClientMessage(unsigned int d, TTV_WebCamDeviceStatus s, const TTV_WebCamDeviceCapability& c, TTV_WebCamDeviceStatusCallback cb, void* ud) 
{ 
	type = ClientMessageType::DeviceStatus;
	err = TTV_EC_SUCCESS;
	deviceIndex = d;
	capabilityIndex = c.capabilityIndex;
	status = s;
	capability = c;
	callback = cb;
	userdata = ud;
}


ttv::cam::DeviceStatusClientMessage::DeviceStatusClientMessage(unsigned int d, TTV_WebCamDeviceStatus s, unsigned int ci, TTV_ErrorCode e, TTV_WebCamDeviceStatusCallback cb, void* ud) 
{ 
	type = ClientMessageType::DeviceStatus;
	err = e;
	deviceIndex = d;
	capabilityIndex = ci;
	status = s;
	callback = cb;
	userdata = ud;
}


ttv::cam::DeviceChangeClientMessage::DeviceChangeClientMessage(std::shared_ptr<VideoCaptureDevice> d, TTV_WebCamDeviceChange ch, TTV_WebCamDeviceChangeCallback cb, void* ud) 
{ 
	type = ClientMessageType::DeviceChange;
	err = TTV_EC_SUCCESS;
	change = ch;
	device = d;
	callback = cb;
	userdata = ud;
}






ttv::cam::SystemMessage::~SystemMessage() 
{
}


ttv::cam::SystemMessage::SystemMessage()
{
	type = SystemMessageType::Invalid;
	userdata = nullptr;
}


ttv::cam::InitializeSystemMessage::InitializeSystemMessage(TTV_WebCamInitializationCallback cb, void* ud) 
{ 
	type = SystemMessageType::Initialize;
	err = TTV_EC_SUCCESS;
	callback = cb;
	userdata = ud;
}


ttv::cam::ShutdownSystemMessage::ShutdownSystemMessage(TTV_WebCamShutdownCallback cb, void* ud) 
{ 
	type = SystemMessageType::Shutdown;
	err = TTV_EC_SUCCESS;
	callback = cb;
	userdata = ud;
}


ttv::cam::DeviceInitializedSystemMessage::DeviceInitializedSystemMessage(int index, TTV_ErrorCode error)
{ 
	type = SystemMessageType::DeviceInitialized;
	err = error;
	deviceIndex = index;
}


ttv::cam::DeviceShutdownSystemMessage::DeviceShutdownSystemMessage(int index, bool initError) 
{
	type = SystemMessageType::DeviceShutdown;
	err = TTV_EC_SUCCESS;
	deviceIndex = index;
	DeviceShutdownSystemMessage::initError = initError;
}


ttv::cam::StartDeviceSystemMessage::StartDeviceSystemMessage(unsigned int index, unsigned int ci, TTV_WebCamDeviceStatusCallback cb, void* ud)
{ 
	type = SystemMessageType::StartDevice;
	err = TTV_EC_SUCCESS;
	deviceIndex = index;
	capabilityIndex = ci;
	callback = cb;
	userdata = ud;
}


ttv::cam::StopDeviceSystemMessage::StopDeviceSystemMessage(int index, TTV_WebCamDeviceStatusCallback cb, void* ud) 
{ 
	type = SystemMessageType::StopDevice;
	err = TTV_EC_SUCCESS;
	deviceIndex = index;
	callback = cb;
	userdata = ud;
}
