/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#include "internal/pch.h"
#include "internal/interfacecontext.h"
#include "internal/twitchapi.h"
#include "internal/webcam/webcamapi.h"
#include "twitchwebcam.h"

TTV_ErrorCode TTV_WebCam_Init(const TTV_WebCamCallbacks* interruptCallbacks, TTV_WebCamInitializationCallback initCallback, void* userdata)
{
	TTV_RETURN_ON_NULL(gInterfaceContext, TTV_EC_NOT_INITIALIZED);

	if (gInterfaceContext->webcamApi != nullptr)
	{
		return TTV_EC_ALREADY_INITIALIZED;
	}

	std::unique_ptr<ttv::cam::WebcamAPI> api = std::make_unique<ttv::cam::WebcamAPI>();
	assert(api);

	if (api == nullptr)
	{
		return TTV_EC_MEMORY;
	}

	TTV_ErrorCode result = api->Init(interruptCallbacks, initCallback, userdata);

	if (TTV_SUCCEEDED(result))
	{
		gInterfaceContext->webcamApi = std::move(api);
	}

	return result;
}

TTV_ErrorCode TTV_WebCam_Shutdown(TTV_WebCamShutdownCallback callback, void* userdata)
{
	TTV_RETURN_ON_NULL(gInterfaceContext, TTV_EC_NOT_INITIALIZED);
	TTV_RETURN_ON_NULL(gInterfaceContext->webcamApi, TTV_EC_NOT_INITIALIZED);

	// TODO: Make this async
	TTV_ErrorCode result = gInterfaceContext->webcamApi->Shutdown(callback, userdata);

	if (TTV_SUCCEEDED(result))
	{
		gInterfaceContext->webcamApi.reset();
	}

	return result;
}


TTV_ErrorCode TTV_WebCam_Start(int deviceIndex, int capabilityIndex, TTV_WebCamDeviceStatusCallback callback, void* userdata)
{
	TTV_RETURN_ON_NULL(gInterfaceContext, TTV_EC_NOT_INITIALIZED);
	TTV_RETURN_ON_NULL(gInterfaceContext->webcamApi, TTV_EC_NOT_INITIALIZED);

	return  gInterfaceContext->webcamApi->Start(deviceIndex, capabilityIndex, callback, userdata);
}


TTV_ErrorCode TTV_WebCam_Stop(int deviceIndex, TTV_WebCamDeviceStatusCallback callback, void* userdata)
{
	TTV_RETURN_ON_NULL(gInterfaceContext, TTV_EC_NOT_INITIALIZED);
	TTV_RETURN_ON_NULL(gInterfaceContext->webcamApi, TTV_EC_NOT_INITIALIZED);

	return  gInterfaceContext->webcamApi->Stop(deviceIndex, callback, userdata);
}


TTV_ErrorCode TTV_WebCam_FlushEvents()
{
	TTV_RETURN_ON_NULL(gInterfaceContext, TTV_EC_NOT_INITIALIZED);
	TTV_RETURN_ON_NULL(gInterfaceContext->webcamApi, TTV_EC_NOT_INITIALIZED);

	return  gInterfaceContext->webcamApi->FlushEvents();
}


TTV_ErrorCode TTV_WebCam_IsFrameAvailable(int deviceIndex, bool* available)
{
	TTV_RETURN_ON_NULL(gInterfaceContext, TTV_EC_NOT_INITIALIZED);
	TTV_RETURN_ON_NULL(gInterfaceContext->webcamApi, TTV_EC_NOT_INITIALIZED);

	return  gInterfaceContext->webcamApi->IsFrameAvailable(deviceIndex, available);
}


TTV_ErrorCode TTV_WebCam_GetFrame(int deviceIndex, void* buffer, unsigned int pitch)
{
	TTV_RETURN_ON_NULL(gInterfaceContext, TTV_EC_NOT_INITIALIZED);
	TTV_RETURN_ON_NULL(gInterfaceContext->webcamApi, TTV_EC_NOT_INITIALIZED);

	return  gInterfaceContext->webcamApi->GetFrame(deviceIndex, buffer, pitch);
}
