/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2016 Twitch Interactive, Inc.
*********************************************************************************************/

#include "internal/pch.h"
#include "internal/webcam/win32/samplegrabbercallback.h"
#include "internal/webcam/win32/directshowvideocapturedevice.h"


void ttv::cam::SampleGrabberCallback::Initialize(const std::weak_ptr<DirectShowVideoCaptureDevice>& that)
{
	mThat = that;
}

STDMETHODIMP ttv::cam::SampleGrabberCallback::QueryInterface(REFIID riid, VOID** ppv)
{
	HRESULT returning = E_NOINTERFACE;

	if (riid == IID_IUnknown
	   || riid == IID_ISampleGrabberCB)
	{
		*ppv = reinterpret_cast<VOID*>(this);
		returning = S_OK;
	}
	return returning;
}

STDMETHODIMP_(ULONG) ttv::cam::SampleGrabberCallback::AddRef()
{
	return 2;
}

STDMETHODIMP_(ULONG) ttv::cam::SampleGrabberCallback::Release()
{
	return 1;
}

STDMETHODIMP ttv::cam::SampleGrabberCallback::SampleCB(double /*SampleTime*/, IMediaSample* /*pSample*/)
{
	return E_NOTIMPL;
}

STDMETHODIMP ttv::cam::SampleGrabberCallback::BufferCB(double /*SampleTime*/, BYTE* pBuffer, long BufferLen)
{
	HRESULT returning = S_OK;

	if (pBuffer == nullptr)
	{
		returning = E_POINTER;
	}
	else
	{
		auto that = mThat.lock();

		// Try and catch the case where the callback is still being called after the call to mSampleGrabber->SetCallback(NULL) returns
		// Probably isn't possible but the documentation is ambiguous.
		assert(that != nullptr && that->mCaptureFrame >= 0);

		// ensure there's a frame to capture to
		if (that != nullptr && that->mCaptureFrame >= 0)
		{
			TTV_WebCamFrame* frame = &(that->mFrames[that->mCaptureFrame]);
			assert(frame->imageBuffer);

			memcpy(frame->imageBuffer, pBuffer, static_cast<size_t>(BufferLen));

			that->SwapFrames();

			// Try and catch the case where the callback is still being called after the call to mSampleGrabber->SetCallback(NULL) returns.
			// Probably isn't possible but the documentation is ambiguous.
			assert(that->mCaptureFrame >= 0);
		}
	}

	return returning;
}
