::  Used by: release-win-bins builder, mock-release-win-bins builder
::
:: Builds the Java tests.
::
:: This script assumes that the current directory is tests/bindings/java/wrapper.

@echo off
:: Capture paths
if exist "%CD%\bin" ( rmdir /Q /S "%CD%\bin" )
mkdir "%CD%\bin"
pushd "%CD%\bin"
set TEST_BIN_DIR=%CD%
echo TEST_BIN_DIR=%TEST_BIN_DIR%
popd

pushd %CD%\..\..\..\..\twitchsdk\bindings\java\src
set TWITCH_SRC_DIR=%CD%
echo TWITCH_SRC_DIR=%TWITCH_SRC_DIR%
popd

pushd %CD%\src
set TEST_SRC_DIR=%CD%
echo TEST_SRC_DIR=%TEST_SRC_DIR%
popd

pushd %CD%\..\..\..\..\twitchsdk\lib
set TWITCH_LIB_DIR=%CD%
echo TWITCH_LIB_DIR=%TWITCH_LIB_DIR%
popd

:: Compile Java wrapper classes
"%JAVA_HOME%\bin\javac.exe" -d "%TEST_BIN_DIR%" %TWITCH_SRC_DIR%\tv\twitch\*.java %TWITCH_SRC_DIR%\tv\twitch\broadcast\*.java %TWITCH_SRC_DIR%\tv\twitch\chat\*.java %TEST_SRC_DIR%\tv\twitch\test\*.java
if %errorlevel% neq 0 exit /b %errorlevel%

:: Copy the Windows 32-bit native libraries
set DEST=%TEST_BIN_DIR%\x86
if NOT exist "%DEST%" ( mkdir %DEST% )
copy /B "%TWITCH_LIB_DIR%\Win32\ReleaseBindings\twitchsdk.dll" "%DEST%\twitchsdk.dll" /Y

for %%a in (ffmpeg libmp3lame intel) do (
	xcopy ..\..\..\..\twitchsdk\%%a\bin\win32 bin\x86 /d /s
)

:: Copy the Windows 64-bit native libraries
set DEST=%TEST_BIN_DIR%\x64
if NOT exist "%DEST%" ( mkdir %DEST% )
copy /B "%TWITCH_LIB_DIR%\x64\ReleaseBindings\twitchsdk.dll" "%DEST%\twitchsdk.dll" /Y

for %%a in (ffmpeg libmp3lame intel) do (
	xcopy ..\..\..\..\twitchsdk\%%a\bin\x64 bin\x64 /d /s
)
